/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core.impl;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.InputLocationTracker;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectRef;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.common.model.Project;
import org.commonjava.maven.ext.common.util.WildcardMap;
import org.commonjava.maven.ext.core.ManipulationSession;
import org.commonjava.maven.ext.core.util.DependencyPluginWrapper;
import org.commonjava.maven.ext.core.util.PropertiesUtils;
import org.commonjava.maven.ext.core.util.PropertyMapper;
import org.commonjava.maven.ext.io.ModelIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonManipulator {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final Map<Project, Map<String, PropertyMapper>> explicitVersionPropertyUpdateMap = new LinkedHashMap<Project, Map<String, PropertyMapper>>();
    protected ModelIO effectiveModelBuilder;
    protected ManipulationSession session;

    protected Map<ArtifactRef, String> applyModuleVersionOverrides(String projectGA, Map<String, String> moduleOverrides, Map<ArtifactRef, String> originalOverrides, WildcardMap<String> explicitOverrides, Map<String, Map<ProjectRef, String>> extraBOMOverrides) throws ManipulationException {
        boolean[] wildcardMode;
        LinkedHashMap<ArtifactRef, String> remainingOverrides = new LinkedHashMap<ArtifactRef, String>(originalOverrides);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Calculating module-specific version overrides. Starting with:{}  {}", (Object)System.lineSeparator(), (Object)StringUtils.join(remainingOverrides.entrySet(), System.lineSeparator() + "  "));
        }
        for (boolean aWildcardMode : wildcardMode = new boolean[]{false, true}) {
            for (Map.Entry<String, String> entry : moduleOverrides.entrySet()) {
                String newArtifactValue;
                String artifactGA;
                String currentKey = entry.getKey();
                String currentValue = entry.getValue();
                boolean isModuleWildcard = currentKey.endsWith("@*");
                this.logger.debug("Processing key {} for override with value '{}' and is wildcard {} and in module wildcard {}", currentKey, currentValue, isModuleWildcard, aWildcardMode);
                if (!currentKey.contains("@")) {
                    this.logger.trace("Not an override. Skip.");
                    continue;
                }
                boolean replace = false;
                if (!aWildcardMode) {
                    if (isModuleWildcard) {
                        this.logger.trace("Not currently in wildcard mode. Skip.");
                        continue;
                    }
                    String[] artifactAndModule = currentKey.split("@");
                    if (artifactAndModule.length != 2) {
                        throw new ManipulationException("Invalid format for exclusion key {}", currentKey);
                    }
                    artifactGA = artifactAndModule[0];
                    ProjectRef moduleGA = SimpleProjectRef.parse(artifactAndModule[1]);
                    this.logger.debug("For artifact override: {}, comparing parsed module: {} to current project: {}", artifactGA, moduleGA, projectGA);
                    if (moduleGA.toString().equals(projectGA) || moduleGA.getArtifactId().equals("*") && SimpleProjectRef.parse(projectGA).getGroupId().equals(moduleGA.getGroupId())) {
                        if (currentValue != null && !currentValue.isEmpty()) {
                            replace = true;
                            this.logger.debug("Overriding module dependency for {} with {} : {}", moduleGA, artifactGA, currentValue);
                        } else {
                            this.removeGA(remainingOverrides, SimpleProjectRef.parse(artifactGA));
                            this.logger.debug("For module {}, ignoring dependency override for {}", (Object)moduleGA, (Object)artifactGA);
                        }
                    }
                } else {
                    if (!isModuleWildcard) {
                        this.logger.debug("Currently in wildcard mode. Skip.");
                        continue;
                    }
                    artifactGA = currentKey.substring(0, currentKey.length() - 2);
                    this.logger.debug("For artifact override: {}, checking if current overrides already contain a module-specific version.", (Object)artifactGA);
                    if (explicitOverrides.containsKey(SimpleProjectRef.parse(artifactGA))) {
                        this.logger.debug("For artifact override: {}, current overrides already contain a module-specific version. Skip.", (Object)artifactGA);
                        continue;
                    }
                    if (currentValue != null && !currentValue.isEmpty()) {
                        this.logger.debug("Overriding module dependency for {} with {} : {}", projectGA, artifactGA, currentValue);
                        replace = true;
                    } else {
                        this.removeGA(remainingOverrides, SimpleProjectRef.parse(artifactGA));
                        this.logger.debug("Removing artifactGA {} from overrides", (Object)artifactGA);
                    }
                }
                if (!replace) continue;
                ProjectRef projectRef = SimpleProjectRef.parse(artifactGA);
                Map<ProjectRef, String> extraBOM = extraBOMOverrides.get(currentValue);
                if (extraBOM == null) {
                    newArtifactValue = currentValue;
                } else {
                    newArtifactValue = extraBOM.get(projectRef);
                    if (newArtifactValue == null) {
                        throw new ManipulationException("Extra BOM {} does not define a version for artifact {} targeted by {}", currentValue, artifactGA, currentKey);
                    }
                    this.logger.debug("Dereferenced value {} for {} from extra BOM {}", newArtifactValue, artifactGA, currentValue);
                }
                explicitOverrides.put(projectRef, newArtifactValue);
            }
        }
        return remainingOverrides;
    }

    private void removeGA(Map<ArtifactRef, String> overrides, ProjectRef ref) {
        Iterator<ArtifactRef> it = overrides.keySet().iterator();
        while (it.hasNext()) {
            ArtifactRef a = it.next();
            if (a.asProjectRef().equals(ref) || ref.getArtifactId().equals("*") && a.getGroupId().equals(ref.getGroupId()) || ref.getGroupId().equals("*") && a.getArtifactId().equals(ref.getArtifactId())) {
                it.remove();
                continue;
            }
            if (!ref.getArtifactId().equals("*") || !ref.getGroupId().equals("*")) continue;
            it.remove();
        }
    }

    protected void applyExplicitOverrides(Project project, Map<? extends ProjectVersionRef, ? extends InputLocationTracker> dependencies, WildcardMap<String> explicitOverrides, Map<Project, Map<String, PropertyMapper>> versionPropertyUpdateMap) throws ManipulationException {
        for (Map.Entry<? extends ProjectVersionRef, ? extends InputLocationTracker> entry : dependencies.entrySet()) {
            ProjectVersionRef projectVersionRef = entry.getKey();
            SimpleProjectRef groupIdArtifactId = new SimpleProjectRef(projectVersionRef.getGroupId(), projectVersionRef.getArtifactId());
            if (!explicitOverrides.containsKey(groupIdArtifactId)) continue;
            String overrideVersion = explicitOverrides.get(groupIdArtifactId);
            DependencyPluginWrapper wrapper = new DependencyPluginWrapper(entry.getValue());
            String oldVersion = wrapper.getVersion();
            if (StringUtils.isEmpty(overrideVersion) || StringUtils.isEmpty(oldVersion)) {
                if (StringUtils.isEmpty(oldVersion)) {
                    this.logger.debug("Unable to force align as no existing version field to update for {}; ignoring", (Object)groupIdArtifactId);
                    continue;
                }
                this.logger.warn("Unable to force align as override version is empty for {}; ignoring", (Object)groupIdArtifactId);
                continue;
            }
            for (String target : overrideVersion.split(",")) {
                if (target.startsWith("+")) {
                    String exclusion = target.substring(1);
                    this.logger.info("Adding dependency exclusion {} to dependency {}", (Object)exclusion, (Object)projectVersionRef);
                    Exclusion e = new Exclusion();
                    e.setGroupId(exclusion.split(":")[0]);
                    e.setArtifactId(target.split(":")[1]);
                    wrapper.addExclusion(e);
                    continue;
                }
                this.logger.info("Explicit overrides : force aligning {} to {}.", (Object)groupIdArtifactId, (Object)target);
                if (PropertiesUtils.cacheProperty(this.session, project, versionPropertyUpdateMap, oldVersion, target, projectVersionRef, true)) continue;
                if (oldVersion.contains("${")) {
                    this.logger.warn("Overriding version with {} when old version contained a property {} that was not found in the current project", (Object)target, (Object)oldVersion);
                }
                wrapper.setVersion(target);
            }
        }
    }

    protected void explicitOverridePropertyUpdates(ManipulationSession session) throws ManipulationException {
        this.logger.debug("Iterating for explicit overrides...");
        for (Map.Entry<Project, Map<String, PropertyMapper>> e : this.explicitVersionPropertyUpdateMap.entrySet()) {
            Project project = e.getKey();
            this.logger.debug("Checking property override within project {}", (Object)project);
            for (Map.Entry<String, PropertyMapper> entry : e.getValue().entrySet()) {
                PropertiesUtils.PropertyUpdate found = PropertiesUtils.updateProperties(session, project, true, entry.getKey(), entry.getValue().getNewVersion());
                if (found != PropertiesUtils.PropertyUpdate.NOTFOUND) continue;
                this.logger.info("Unable to find a property for {} to update for explicit overrides", (Object)entry.getKey());
                this.logger.info("Adding property {} with {}", (Object)entry.getKey(), (Object)entry.getValue().getNewVersion());
                project.getInheritedList().get(0).getModel().getProperties().setProperty(entry.getKey(), entry.getValue().getNewVersion());
            }
        }
    }
}

