/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.io.checksum;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.commonjava.maven.galley.io.checksum.AbstractChecksumGenerator;
import org.commonjava.maven.galley.io.checksum.AbstractChecksumGeneratorFactory;
import org.commonjava.maven.galley.io.checksum.ContentDigest;
import org.commonjava.maven.galley.io.checksum.TransferMetadata;
import org.commonjava.maven.galley.io.checksum.TransferMetadataConsumer;
import org.commonjava.maven.galley.model.Transfer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ChecksummingOutputStream
extends FilterOutputStream {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Set<AbstractChecksumGenerator> checksums;
    private long size = 0L;
    private final Transfer transfer;
    private final TransferMetadataConsumer metadataConsumer;
    private final boolean writeChecksumFiles;

    public ChecksummingOutputStream(Set<AbstractChecksumGeneratorFactory<?>> checksumFactories, OutputStream stream, Transfer transfer, TransferMetadataConsumer metadataConsumer, boolean writeChecksumFiles) throws IOException {
        super(stream);
        this.transfer = transfer;
        this.metadataConsumer = metadataConsumer;
        this.writeChecksumFiles = writeChecksumFiles;
        this.checksums = new HashSet<AbstractChecksumGenerator>();
        for (AbstractChecksumGeneratorFactory<?> factory : checksumFactories) {
            this.checksums.add((AbstractChecksumGenerator)factory.createGenerator(transfer, writeChecksumFiles));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.logger.trace("START CLOSE: {}", (Object)this.transfer);
            super.flush();
            this.logger.trace("Wrote: {} (size: {}) in: {}. Now, writing checksums.", this.transfer.getPath(), this.size, this.transfer.getLocation());
            HashMap<ContentDigest, String> hexDigests = new HashMap<ContentDigest, String>();
            for (AbstractChecksumGenerator checksum : this.checksums) {
                hexDigests.put(checksum.getDigestType(), checksum.getDigestHex());
                if (!this.writeChecksumFiles) continue;
                checksum.write();
            }
            if (this.metadataConsumer != null) {
                this.metadataConsumer.addMetadata(this.transfer, new TransferMetadata(hexDigests, this.size));
            } else {
                this.logger.trace("No metadata consumer!");
            }
        }
        finally {
            super.close();
            this.logger.trace("END CLOSE: {}", (Object)this.transfer);
        }
    }

    @Override
    public void write(int data) throws IOException {
        super.write(data);
        ++this.size;
        byte b = (byte)(data & 0xFF);
        for (AbstractChecksumGenerator checksum : this.checksums) {
            checksum.update(b);
        }
    }
}

