/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.model;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.lang.StringUtils;
import org.commonjava.maven.galley.event.EventMetadata;
import org.commonjava.maven.galley.event.FileAccessEvent;
import org.commonjava.maven.galley.event.FileDeletionEvent;
import org.commonjava.maven.galley.event.FileErrorEvent;
import org.commonjava.maven.galley.event.FileStorageEvent;
import org.commonjava.maven.galley.io.OverriddenBooleanValue;
import org.commonjava.maven.galley.model.ConcreteResource;
import org.commonjava.maven.galley.model.Location;
import org.commonjava.maven.galley.model.TransferOperation;
import org.commonjava.maven.galley.spi.cache.CacheProvider;
import org.commonjava.maven.galley.spi.event.FileEventManager;
import org.commonjava.maven.galley.spi.io.TransferDecorator;
import org.commonjava.maven.galley.util.TransferInputStream;
import org.commonjava.maven.galley.util.TransferOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Transfer {
    public static final String DELETE_CONTENT_LOG = "org.commonjava.topic.content.delete";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ConcreteResource resource;
    private final CacheProvider provider;
    private final TransferDecorator decorator;
    private final FileEventManager fileEventManager;

    public Transfer(Location loc, CacheProvider provider, FileEventManager fileEventManager, TransferDecorator decorator, String ... path) {
        this.resource = new ConcreteResource(loc, path);
        this.fileEventManager = fileEventManager;
        this.decorator = decorator;
        this.provider = provider;
    }

    public Transfer(ConcreteResource resource, CacheProvider provider, FileEventManager fileEventManager, TransferDecorator decorator) {
        this.resource = resource;
        this.fileEventManager = fileEventManager;
        this.decorator = decorator;
        this.provider = provider;
    }

    public boolean isDirectory() {
        return this.provider.isDirectory(this.resource);
    }

    public boolean isFile() {
        return this.provider.isFile(this.resource);
    }

    public Location getLocation() {
        return this.resource.getLocation();
    }

    public String getPath() {
        return this.resource.getPath();
    }

    public ConcreteResource getResource() {
        return this.resource;
    }

    public String toString() {
        return String.format("%s:%s (stored at: %s)", this.resource.getLocation(), this.resource.getPath(), this.provider.getFilePath(this.resource));
    }

    public Transfer getParent() {
        if (this.resource.isRoot()) {
            return this;
        }
        return this.provider.getTransfer(this.resource.getParent());
    }

    public Transfer getChild(String file) {
        return this.provider.getTransfer(this.resource.getChild(file));
    }

    public void touch() {
        this.touch(new EventMetadata());
    }

    public void touch(EventMetadata eventMetadata) {
        if (this.decorator != null) {
            this.decorator.decorateTouch(this, eventMetadata);
        }
        this.fileEventManager.fire(new FileAccessEvent(this, eventMetadata));
    }

    public InputStream openInputStream() throws IOException {
        return this.openInputStream(true, new EventMetadata());
    }

    public InputStream openInputStream(boolean fireEvents) throws IOException {
        return this.openInputStream(fireEvents, new EventMetadata());
    }

    public InputStream openInputStream(boolean fireEvents, EventMetadata eventMetadata) throws IOException {
        this.provider.waitForReadUnlock(this.resource);
        try {
            InputStream stream = this.provider.openInputStream(this.resource);
            if (stream == null) {
                return null;
            }
            if (fireEvents) {
                stream = new TransferInputStream(stream, new FileAccessEvent(this, eventMetadata), this.fileEventManager);
            }
            stream = this.decorator == null ? stream : this.decorator.decorateRead(stream, this, eventMetadata);
            this.logger.trace("Returning stream: {} for transfer: {}", (Object)stream.getClass().getName(), (Object)this);
            return stream;
        }
        catch (IOException e) {
            if (fireEvents) {
                this.fileEventManager.fire(new FileErrorEvent(this, e, eventMetadata));
            }
            throw e;
        }
    }

    public OutputStream openOutputStream(TransferOperation accessType) throws IOException {
        return this.openOutputStream(accessType, true);
    }

    public OutputStream openOutputStream(TransferOperation accessType, boolean fireEvents) throws IOException {
        return this.openOutputStream(accessType, fireEvents, new EventMetadata());
    }

    public OutputStream openOutputStream(TransferOperation accessType, boolean fireEvents, EventMetadata eventMetadata) throws IOException {
        return this.openOutputStream(accessType, fireEvents, eventMetadata, false);
    }

    public OutputStream openOutputStream(TransferOperation accessType, boolean fireEvents, EventMetadata eventMetadata, boolean deleteFilesOnPath) throws IOException {
        this.provider.waitForWriteUnlock(this.resource);
        try {
            OutputStream stream;
            this.provider.lockWrite(this.resource);
            if (deleteFilesOnPath) {
                this.deleteFilesOnPath();
            }
            if ((stream = this.provider.openOutputStream(this.resource)) == null) {
                return null;
            }
            TransferUnlocker unlocker = new TransferUnlocker(this.resource, this.provider);
            if (fireEvents) {
                this.logger.info("Wrapping output stream to: {} using event metadata: {}", (Object)this, (Object)eventMetadata);
                stream = new TransferOutputStream(stream, unlocker, new FileStorageEvent(accessType, this, eventMetadata), this.fileEventManager);
            } else {
                this.logger.info("Wrapping output stream to: {} WITHOUT event metadata", (Object)this);
                stream = new TransferOutputStream(stream, unlocker);
            }
            stream = this.decorator == null ? stream : this.decorator.decorateWrite(stream, this, accessType, eventMetadata);
            return stream;
        }
        catch (IOException e) {
            if (fireEvents) {
                this.fileEventManager.fire(new FileErrorEvent(this, e, eventMetadata));
            }
            throw e;
        }
    }

    private void deleteFilesOnPath() throws IOException {
        ConcreteResource currentRes = this.resource;
        while (!this.provider.exists(currentRes) && !currentRes.isRoot()) {
            currentRes = currentRes.getParent();
        }
        if (this.provider.exists(currentRes) && this.provider.isFile(currentRes)) {
            this.provider.delete(currentRes);
        }
    }

    public boolean exists(EventMetadata eventMetadata) {
        OverriddenBooleanValue overriden = null;
        if (this.decorator != null) {
            overriden = this.decorator.decorateExists(this, eventMetadata);
        }
        if (overriden != null && overriden.overrides()) {
            return overriden.getResult();
        }
        return this.provider.exists(this.resource);
    }

    public boolean exists() {
        return this.exists(new EventMetadata());
    }

    public void copyFrom(Transfer f) throws IOException {
        this.copyFrom(f, new EventMetadata());
    }

    public void copyFrom(Transfer f, EventMetadata eventMetadata) throws IOException {
        this.provider.waitForWriteUnlock(this.resource);
        this.provider.lockWrite(this.resource);
        try {
            if (this.decorator != null) {
                this.decorator.decorateCopyFrom(f, this, eventMetadata);
            }
            this.provider.copy(f.getResource(), this.resource);
        }
        finally {
            this.provider.unlockWrite(this.resource);
        }
    }

    public String getFullPath() {
        return this.provider.getFilePath(this.resource);
    }

    public boolean delete() throws IOException {
        return this.delete(true, new EventMetadata());
    }

    public boolean delete(boolean fireEvents) throws IOException {
        return this.delete(fireEvents, new EventMetadata());
    }

    public boolean delete(boolean fireEvents, EventMetadata eventMetadata) throws IOException {
        this.provider.waitForWriteUnlock(this.resource);
        if (!this.resource.allowsDeletion()) {
            throw new IOException("Deletion not allowed for: " + this.resource);
        }
        try {
            Logger contentLogger;
            if (this.decorator != null) {
                this.decorator.decorateDelete(this, eventMetadata);
            }
            if ((contentLogger = LoggerFactory.getLogger(DELETE_CONTENT_LOG)).isTraceEnabled()) {
                contentLogger.trace("Starting delete of: {} ({}) from:\n    ", this.resource, eventMetadata, StringUtils.join((Object[])Thread.currentThread().getStackTrace(), "\n    "));
            } else {
                contentLogger.info("Starting delete of: {} ({})", (Object)this.resource, (Object)eventMetadata);
            }
            boolean deleted = this.provider.delete(this.resource);
            if (deleted) {
                contentLogger.info("Finished delete of: {}", (Object)this.resource);
                if (fireEvents) {
                    this.fileEventManager.fire(new FileDeletionEvent(this, eventMetadata));
                }
            } else {
                contentLogger.info("Failed to delete: {}", (Object)this.resource);
            }
            return deleted;
        }
        catch (IOException e) {
            if (fireEvents) {
                this.fileEventManager.fire(new FileErrorEvent(this, e, eventMetadata));
            }
            throw e;
        }
    }

    public String[] list() throws IOException {
        String[] listing = this.provider.list(this.resource);
        if (this.decorator != null) {
            listing = this.decorator.decorateListing(this, listing, new EventMetadata());
        }
        return listing;
    }

    public File getDetachedFile() {
        this.provider.waitForWriteUnlock(this.resource);
        this.provider.lockWrite(this.resource);
        try {
            File file = this.provider.asAdminView().getDetachedFile(this.resource);
            return file;
        }
        finally {
            this.provider.unlockWrite(this.resource);
        }
    }

    public void mkdirs() throws IOException {
        if (this.decorator != null) {
            this.decorator.decorateMkdirs(this, new EventMetadata());
        }
        this.provider.mkdirs(this.resource);
    }

    public void createFile() throws IOException {
        this.provider.waitForWriteUnlock(this.resource);
        if (this.decorator != null) {
            this.decorator.decorateCreateFile(this, new EventMetadata());
        }
        this.provider.createFile(this.resource);
    }

    public long length() {
        return this.provider.length(this.resource);
    }

    public long lastModified() {
        return this.provider.lastModified(this.resource);
    }

    public Transfer getSibling(String named) {
        if (this.resource.isRoot()) {
            return null;
        }
        return this.getParent().getChild(named);
    }

    public Transfer getSiblingMeta(String extension) {
        if (this.resource.isRoot()) {
            return null;
        }
        final String named = this.resource.getPath() + extension;
        final Transfer tx = this;
        this.logger.debug("Creating meta-transfer sibling for: {}", new Object(){

            public String toString() {
                return tx + " with name: " + named + " (parent: " + tx.getParent() + ")";
            }
        });
        return this.provider.getTransfer(new ConcreteResource(this.getLocation(), named));
    }

    public void lockWrite() {
        this.provider.lockWrite(this.resource);
    }

    public void unlock() {
        this.provider.unlockWrite(this.resource);
    }

    public boolean isWriteLocked() {
        return this.provider.isWriteLocked(this.resource);
    }

    public TransferDecorator getDecorator() {
        return this.decorator;
    }

    public void setResource(ConcreteResource resource) {
        this.resource = resource;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Transfer)) {
            return false;
        }
        Transfer transfer = (Transfer)o;
        return this.resource.equals(transfer.resource);
    }

    public int hashCode() {
        return this.resource.hashCode();
    }

    public static final class TransferUnlocker {
        private final CacheProvider provider;
        private final ConcreteResource resource;

        private TransferUnlocker(ConcreteResource resource, CacheProvider provider) {
            this.resource = resource;
            this.provider = provider;
        }

        public void unlock() {
            this.provider.unlockWrite(this.resource);
        }
    }
}

