/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.util.jhttpc.auth;

import org.commonjava.util.jhttpc.auth.PasswordType;
import org.commonjava.util.jhttpc.model.SiteConfig;

public class PasswordKey {
    private final String siteId;
    private final PasswordType passwordType;

    public PasswordKey(SiteConfig config, PasswordType type) {
        this(config.getId(), type);
    }

    public PasswordKey(String siteId, PasswordType passwordType) {
        if (siteId == null || siteId.trim().length() < 1) {
            throw new IllegalArgumentException("Empty/missing siteId!");
        }
        if (passwordType == null) {
            throw new IllegalArgumentException("Missing passwordType!");
        }
        this.siteId = siteId;
        this.passwordType = passwordType;
    }

    public String getSiteId() {
        return this.siteId;
    }

    public PasswordType getPasswordType() {
        return this.passwordType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.siteId.hashCode();
        result = 31 * result + (this.passwordType == null ? 0 : this.passwordType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PasswordKey other = (PasswordKey)obj;
        if (!this.siteId.equals(other.siteId)) {
            return false;
        }
        return !(this.passwordType == null ? other.passwordType != null : !this.passwordType.equals((Object)other.passwordType));
    }
}

