/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.da.lookup.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.Set;
import lombok.NonNull;
import org.jboss.da.model.rest.GAV;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=MavenLookupRequestBuilder.class)
public class MavenLookupRequest {
    @NonNull
    private final Set<GAV> artifacts;
    @NonNull
    private final String mode;
    @JsonProperty(defaultValue="false")
    private final boolean brewPullActive;

    MavenLookupRequest(@NonNull Set<GAV> artifacts, @NonNull String mode, boolean brewPullActive) {
        if (artifacts == null) {
            throw new NullPointerException("artifacts is marked non-null but is null");
        }
        if (mode == null) {
            throw new NullPointerException("mode is marked non-null but is null");
        }
        this.artifacts = artifacts;
        this.mode = mode;
        this.brewPullActive = brewPullActive;
    }

    public static MavenLookupRequestBuilder builder() {
        return new MavenLookupRequestBuilder();
    }

    @NonNull
    public Set<GAV> getArtifacts() {
        return this.artifacts;
    }

    @NonNull
    public String getMode() {
        return this.mode;
    }

    public boolean isBrewPullActive() {
        return this.brewPullActive;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MavenLookupRequest)) {
            return false;
        }
        MavenLookupRequest other = (MavenLookupRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isBrewPullActive() != other.isBrewPullActive()) {
            return false;
        }
        Set<GAV> this$artifacts = this.getArtifacts();
        Set<GAV> other$artifacts = other.getArtifacts();
        if (this$artifacts == null ? other$artifacts != null : !((Object)this$artifacts).equals(other$artifacts)) {
            return false;
        }
        String this$mode = this.getMode();
        String other$mode = other.getMode();
        return !(this$mode == null ? other$mode != null : !this$mode.equals(other$mode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MavenLookupRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isBrewPullActive() ? 79 : 97);
        Set<GAV> $artifacts = this.getArtifacts();
        result = result * 59 + ($artifacts == null ? 43 : ((Object)$artifacts).hashCode());
        String $mode = this.getMode();
        result = result * 59 + ($mode == null ? 43 : $mode.hashCode());
        return result;
    }

    public String toString() {
        return "MavenLookupRequest(artifacts=" + this.getArtifacts() + ", mode=" + this.getMode() + ", brewPullActive=" + this.isBrewPullActive() + ")";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class MavenLookupRequestBuilder {
        private Set<GAV> artifacts;
        private String mode;
        private boolean brewPullActive;

        MavenLookupRequestBuilder() {
        }

        public MavenLookupRequestBuilder artifacts(@NonNull Set<GAV> artifacts) {
            if (artifacts == null) {
                throw new NullPointerException("artifacts is marked non-null but is null");
            }
            this.artifacts = artifacts;
            return this;
        }

        public MavenLookupRequestBuilder mode(@NonNull String mode) {
            if (mode == null) {
                throw new NullPointerException("mode is marked non-null but is null");
            }
            this.mode = mode;
            return this;
        }

        @JsonProperty(defaultValue="false")
        public MavenLookupRequestBuilder brewPullActive(boolean brewPullActive) {
            this.brewPullActive = brewPullActive;
            return this;
        }

        public MavenLookupRequest build() {
            return new MavenLookupRequest(this.artifacts, this.mode, this.brewPullActive);
        }

        public String toString() {
            return "MavenLookupRequest.MavenLookupRequestBuilder(artifacts=" + this.artifacts + ", mode=" + this.mode + ", brewPullActive=" + this.brewPullActive + ")";
        }
    }
}

