/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.atlas.ident.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.commonjava.maven.atlas.ident.version.part.SnapshotPart;

public class SnapshotUtils {
    private static final String LAST_UPDATED_FORMAT = "yyyyMMddHHmmss";
    public static final String SNAPSHOT_TSTAMP_FORMAT = "yyyyMMdd.HHmmss";
    public static final String RAW_REMOTE_SNAPSHOT_PART_PATTERN = "([0-9]{8}.[0-9]{6})-([0-9]+)";
    public static final String REMOTE_SNAPSHOT_PART_PATTERN = "^((.+)-)?([0-9]{8}.[0-9]{6})-([0-9]+)$";
    public static final String LOCAL_SNAPSHOT_VERSION_PART = "-SNAPSHOT";

    public static String generateSnapshotSuffix(Date d, int buildNumber) {
        return SnapshotUtils.generateSnapshotTimestamp(d) + "-" + buildNumber;
    }

    public static String generateSnapshotTimestamp(Date d) {
        return SnapshotUtils.getFormat().format(d);
    }

    public static Date getCurrentTimestamp() {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        cal.set(14, 0);
        return cal.getTime();
    }

    public static boolean isSnapshotVersion(String literal) {
        return literal.endsWith(LOCAL_SNAPSHOT_VERSION_PART) || SnapshotUtils.isRemoteSnapshotVersion(literal);
    }

    public static boolean isRemoteSnapshotVersion(String literal) {
        return literal.matches(REMOTE_SNAPSHOT_PART_PATTERN);
    }

    public static boolean isRemoteSnapshotVersionPart(String literal) {
        return literal.matches(REMOTE_SNAPSHOT_PART_PATTERN);
    }

    public static SnapshotPart parseRemoteSnapshotVersionPart(String literal) {
        Pattern pattern = Pattern.compile(REMOTE_SNAPSHOT_PART_PATTERN);
        Matcher matcher = pattern.matcher(literal);
        if (matcher.matches()) {
            String tstamp = matcher.group(3);
            String bn = matcher.group(4);
            if (tstamp != null || bn != null) {
                Date d;
                try {
                    d = SnapshotUtils.parseSnapshotTimestamp(tstamp);
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException("'" + literal + "' is not a remote snapshot version-part (of the format: " + SNAPSHOT_TSTAMP_FORMAT + "-NN (invalid timestamp)", e);
                }
                int build = Integer.parseInt(bn);
                return new SnapshotPart(d, build, literal);
            }
        }
        throw new IllegalArgumentException("'" + literal + "' is not a remote snapshot version-part (of the format: " + SNAPSHOT_TSTAMP_FORMAT + "-NN");
    }

    public static Date parseSnapshotTimestamp(String tstamp) throws ParseException {
        return SnapshotUtils.getFormat().parse(tstamp);
    }

    private static DateFormat getFormat() {
        SimpleDateFormat fmt = new SimpleDateFormat(SNAPSHOT_TSTAMP_FORMAT);
        return fmt;
    }

    public static SnapshotPart extractSnapshotVersionPart(String version) {
        SnapshotPart part = null;
        if (SnapshotUtils.isRemoteSnapshotVersion(version)) {
            part = SnapshotUtils.parseRemoteSnapshotVersionPart(version);
        } else if (version.endsWith(LOCAL_SNAPSHOT_VERSION_PART)) {
            part = new SnapshotPart(LOCAL_SNAPSHOT_VERSION_PART);
        }
        return part;
    }

    public static String generateUpdateTimestamp(Date d) {
        return new SimpleDateFormat(LAST_UPDATED_FORMAT).format(d);
    }

    public static Date parseUpdateTimestamp(String tstamp) throws ParseException {
        return new SimpleDateFormat(LAST_UPDATED_FORMAT).parse(tstamp);
    }
}

