/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.common.util;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.maven.model.Dependency;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WildcardMap<T> {
    public static final String WILDCARD = "*";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, Map<String, T>> map = new LinkedHashMap<String, Map<String, T>>();

    public int size() {
        return this.map.size();
    }

    public boolean containsKey(Dependency key) {
        String groupId = key.getGroupId();
        String artifactId = key.getArtifactId();
        return this.internalContainsKey(groupId, artifactId);
    }

    public boolean containsKey(ProjectRef key) {
        String groupId = key.getGroupId();
        String artifactId = key.getArtifactId();
        return this.internalContainsKey(groupId, artifactId);
    }

    private boolean internalContainsKey(String groupId, String artifactId) {
        Map<String, T> vMap = this.map.get(groupId);
        boolean result = vMap == null || vMap.isEmpty() ? false : (vMap.get(WILDCARD) != null ? true : vMap.containsKey(artifactId));
        return result;
    }

    public void put(ProjectRef key, T value) {
        String groupId = key.getGroupId();
        String artifactId = key.getArtifactId();
        Map<String, T> vMap = this.map.get(groupId);
        if (vMap == null) {
            vMap = new LinkedHashMap<String, T>();
        }
        boolean wildcard = false;
        if (WILDCARD.equals(artifactId)) {
            if (!vMap.isEmpty()) {
                this.logger.warn("Emptying map with keys {} as replacing with wildcard mapping {}", (Object)vMap.keySet(), (Object)key);
            }
            vMap.clear();
        } else {
            for (String o : vMap.keySet()) {
                if (!o.equals(WILDCARD)) continue;
                wildcard = true;
                break;
            }
        }
        if (wildcard) {
            this.logger.warn("Unable to add {} with value {} as wildcard mapping for {} already exists.", key, value, groupId);
        } else {
            vMap.put(artifactId, value);
            this.map.put(groupId, vMap);
        }
    }

    public T get(Dependency key) {
        String groupId = key.getGroupId();
        String artifactId = key.getArtifactId();
        return this.get(groupId, artifactId);
    }

    public T get(ProjectRef key) {
        String groupId = key.getGroupId();
        String artifactId = key.getArtifactId();
        return this.get(groupId, artifactId);
    }

    private T get(String groupId, String artifactId) {
        T result = null;
        Map<String, T> value = this.map.get(groupId);
        if (value != null) {
            result = value.get(WILDCARD) != null ? (T)value.get(WILDCARD) : (T)value.get(artifactId);
        }
        return result;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public String toString() {
        return "WildcardMap{map=" + this.map + '}';
    }
}

