/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core.groovy;

import java.util.List;
import org.apache.groovy.ast.tools.ClassNodeUtils;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.PackageNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.EmptyExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.AbstractASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.commonjava.maven.ext.common.ManipulationUncheckedException;
import org.commonjava.maven.ext.core.groovy.BaseScript;
import org.commonjava.maven.ext.core.groovy.GMEBaseScript;
import org.commonjava.maven.ext.core.groovy.GradleBaseScript;
import org.commonjava.maven.ext.core.groovy.InvocationPoint;
import org.commonjava.maven.ext.core.groovy.PMEBaseScript;
import org.commonjava.maven.ext.core.groovy.SBTBaseScript;
import org.commonjava.maven.ext.core.groovy.SMEGBaseScript;

@GroovyASTTransformation(phase=CompilePhase.SEMANTIC_ANALYSIS)
public class ASTTransformer
extends AbstractASTTransformation {
    private static final ClassNode MAVEN_TYPE = ClassHelper.make(PMEBaseScript.class);
    private static final ClassNode GRADLE_TYPE = ClassHelper.make(GMEBaseScript.class);
    private static final ClassNode SBT_TYPE = ClassHelper.make(SMEGBaseScript.class);
    private static final ClassNode COMMAND_TYPE = ClassHelper.make(InvocationPoint.class);
    private static final ClassNode MAVEN_BASE_SCRIPT_TYPE = ClassHelper.make(BaseScript.class);
    private static final String MAVEN_TYPE_NAME = "@" + MAVEN_TYPE.getNameWithoutPackage();
    private static final ClassNode GRADLE_BASE_SCRIPT_TYPE = ClassHelper.make(GradleBaseScript.class);
    private static final ClassNode SBT_BASE_SCRIPT_TYPE = ClassHelper.make(SBTBaseScript.class);
    private static final String GRADLE_TYPE_NAME = "@" + GRADLE_TYPE.getNameWithoutPackage();
    private static final String SBT_TYPE_NAME = "@" + SBT_TYPE.getNameWithoutPackage();
    private Type type;
    private static final Parameter[] CONTEXT_CTOR_PARAMETERS = new Parameter[]{new Parameter(ClassHelper.BINDING_TYPE, "context")};

    @Override
    public void visit(ASTNode[] nodes, SourceUnit source) {
        this.init(nodes, source);
        AnnotatedNode parent = (AnnotatedNode)nodes[1];
        AnnotationNode node = (AnnotationNode)nodes[0];
        if (MAVEN_TYPE.equals(node.getClassNode()) || GRADLE_TYPE.equals(node.getClassNode()) || SBT_TYPE.equals(node.getClassNode())) {
            if (MAVEN_TYPE.equals(node.getClassNode())) {
                this.type = Type.MAVEN;
            } else if (GRADLE_TYPE.equals(node.getClassNode())) {
                this.type = Type.GRADLE;
            } else if (SBT_TYPE.equals(node.getClassNode())) {
                this.type = Type.SBT;
            }
            if (parent instanceof DeclarationExpression) {
                this.changeBaseScriptTypeFromDeclaration((DeclarationExpression)parent, node);
            } else if (parent instanceof ImportNode || parent instanceof PackageNode) {
                this.changeBaseScriptTypeFromPackageOrImport(source, parent, node);
            } else if (parent instanceof ClassNode) {
                this.changeBaseScriptTypeFromClass((ClassNode)parent);
            }
        }
    }

    private String getType() {
        switch (this.type) {
            case MAVEN: {
                return MAVEN_TYPE_NAME;
            }
            case GRADLE: {
                return GRADLE_TYPE_NAME;
            }
            case SBT: {
                return SBT_TYPE_NAME;
            }
        }
        throw new ManipulationUncheckedException("Unknown type " + (Object)((Object)this.type), new Object[0]);
    }

    private ClassNode getType(Type type) {
        switch (type) {
            case MAVEN: {
                return MAVEN_BASE_SCRIPT_TYPE;
            }
            case GRADLE: {
                return GRADLE_BASE_SCRIPT_TYPE;
            }
            case SBT: {
                return SBT_BASE_SCRIPT_TYPE;
            }
        }
        throw new ManipulationUncheckedException("Unknown type " + (Object)((Object)type), new Object[0]);
    }

    private void changeBaseScriptTypeFromPackageOrImport(SourceUnit source, AnnotatedNode parent, AnnotationNode node) {
        ClassNode scriptType;
        Expression value = node.getMember("value");
        if (value == null) {
            scriptType = this.getType(this.type);
        } else {
            if (!(value instanceof ClassExpression)) {
                this.addError("Annotation " + this.getType() + " member 'value' should be a class literal.", value);
                return;
            }
            scriptType = value.getType();
        }
        List<ClassNode> classes = source.getAST().getClasses();
        for (ClassNode classNode : classes) {
            if (!classNode.isScriptBody()) continue;
            this.changeBaseScriptType(parent, classNode, scriptType);
        }
    }

    private void changeBaseScriptTypeFromClass(ClassNode parent) {
        this.changeBaseScriptType(parent, parent, parent.getSuperClass());
    }

    private void changeBaseScriptTypeFromDeclaration(DeclarationExpression de, AnnotationNode node) {
        if (de.isMultipleAssignmentDeclaration()) {
            this.addError("Annotation " + this.getType() + " not supported with multiple assignment notation.", de);
            return;
        }
        if (!(de.getRightExpression() instanceof EmptyExpression)) {
            this.addError("Annotation " + this.getType() + " not supported with variable assignment.", de);
            return;
        }
        Expression value = node.getMember("value");
        if (value != null) {
            this.addError("Annotation " + this.getType() + " cannot have member 'value' if used on a declaration.", value);
            return;
        }
        ClassNode cNode = de.getDeclaringClass();
        ClassNode baseScriptType = de.getVariableExpression().getType().getPlainNodeReference();
        if (baseScriptType.isScript()) {
            if (!(de.getRightExpression() instanceof EmptyExpression)) {
                this.addError("Annotation " + this.getType() + " not supported with variable assignment.", de);
                return;
            }
            de.setRightExpression(new VariableExpression("this"));
        } else {
            baseScriptType = this.getType(this.type);
        }
        this.changeBaseScriptType(de, cNode, baseScriptType);
    }

    private void changeBaseScriptType(AnnotatedNode parent, ClassNode cNode, ClassNode baseScriptType) {
        MethodNode defaultMethod;
        if (!cNode.isScriptBody()) {
            this.addError("Annotation " + this.getType() + " can only be used within a Script.", parent);
            return;
        }
        if (!baseScriptType.isScript()) {
            this.addError("Declared type " + baseScriptType + " does not extend groovy.lang.Script class!", parent);
            return;
        }
        List<AnnotationNode> annotations = parent.getAnnotations(COMMAND_TYPE);
        if (cNode.getAnnotations(COMMAND_TYPE).isEmpty()) {
            cNode.addAnnotations(annotations);
        }
        cNode.setSuperClass(baseScriptType);
        MethodNode runScriptMethod = ClassHelper.findSAM(baseScriptType);
        if (ASTTransformer.isCustomScriptBodyMethod(runScriptMethod) && (defaultMethod = cNode.getDeclaredMethod("run", Parameter.EMPTY_ARRAY)) != null) {
            cNode.removeMethod(defaultMethod);
            MethodNode methodNode = new MethodNode(runScriptMethod.getName(), runScriptMethod.getModifiers() & 0xFFFFFBFF, runScriptMethod.getReturnType(), runScriptMethod.getParameters(), runScriptMethod.getExceptions(), defaultMethod.getCode());
            methodNode.copyNodeMetaData(defaultMethod);
            ClassNodeUtils.addGeneratedMethod(cNode, methodNode);
        }
        if (cNode.getSuperClass().getDeclaredConstructor(CONTEXT_CTOR_PARAMETERS) == null) {
            ConstructorNode orphanedConstructor = cNode.getDeclaredConstructor(CONTEXT_CTOR_PARAMETERS);
            cNode.removeConstructor(orphanedConstructor);
        }
    }

    private static boolean isCustomScriptBodyMethod(MethodNode node) {
        return node != null && (!node.getDeclaringClass().equals(ClassHelper.SCRIPT_TYPE) || !"run".equals(node.getName()) || node.getParameters().length != 0);
    }

    static enum Type {
        GRADLE,
        MAVEN,
        SBT;

    }
}

