/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Profile;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectRef;
import org.commonjava.maven.ext.common.model.Project;
import org.commonjava.maven.ext.common.util.ProfileUtils;
import org.commonjava.maven.ext.core.ManipulationSession;
import org.commonjava.maven.ext.core.state.PluginRemovalState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasePluginRemovalManipulator {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected ManipulationSession session;

    protected Set<Project> applyChanges(List<Project> projects, PluginRemovalState state) {
        if (!this.session.isEnabled() || !state.isEnabled()) {
            this.logger.debug("{}: Nothing to do!", (Object)this.getClass().getSimpleName());
            return Collections.emptySet();
        }
        HashSet<Project> changed = new HashSet<Project>();
        for (Project project : projects) {
            Model model;
            if (!this.apply(project, model = project.getModel(), state)) continue;
            changed.add(project);
        }
        return changed;
    }

    protected boolean apply(Project project, Model model, PluginRemovalState state) {
        this.logger.debug("Applying plugin changes to: {}:{}", (Object)project.getGroupId(), (Object)project.getArtifactId());
        boolean result = false;
        List<ProjectRef> pluginsToRemove = state.getPluginRemoval();
        if (model.getBuild() != null) {
            result = this.scanPlugins(pluginsToRemove, model.getBuild().getPlugins());
        }
        for (Profile profile : ProfileUtils.getProfiles(this.session, model)) {
            if (profile.getBuild() == null || !this.scanPlugins(pluginsToRemove, profile.getBuild().getPlugins())) continue;
            result = true;
        }
        return result;
    }

    private boolean scanPlugins(List<ProjectRef> pluginsToRemove, List<Plugin> plugins) {
        boolean result = false;
        if (plugins != null) {
            Iterator<Plugin> it = plugins.iterator();
            while (it.hasNext()) {
                Plugin p = it.next();
                if (!pluginsToRemove.contains(SimpleProjectRef.parse(p.getKey()))) continue;
                this.logger.debug("Removing {}", (Object)p);
                it.remove();
                result = true;
            }
        }
        return result;
    }
}

