/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Profile;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.common.model.Project;
import org.commonjava.maven.ext.core.ManipulationSession;
import org.commonjava.maven.ext.core.impl.Manipulator;
import org.commonjava.maven.ext.core.state.DependencyRemovalState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="dependency-removal-manipulator")
@Singleton
public class DependencyRemovalManipulator
implements Manipulator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ManipulationSession session;

    @Override
    public void init(ManipulationSession session) {
        session.setState(new DependencyRemovalState(session.getUserProperties()));
        this.session = session;
    }

    @Override
    public Set<Project> applyChanges(List<Project> projects) throws ManipulationException {
        DependencyRemovalState state = this.session.getState(DependencyRemovalState.class);
        if (!this.session.isEnabled() || !state.isEnabled()) {
            this.logger.debug("{}: Nothing to do!", (Object)this.getClass().getSimpleName());
            return Collections.emptySet();
        }
        HashSet<Project> changed = new HashSet<Project>();
        for (Project project : projects) {
            Model model;
            if (!this.apply(project, model = project.getModel())) continue;
            changed.add(project);
        }
        return changed;
    }

    private boolean apply(Project project, Model model) throws ManipulationException {
        int index;
        Map<ArtifactRef, Dependency> resolvedDependencies;
        Profile profile;
        DependencyRemovalState state = this.session.getState(DependencyRemovalState.class);
        this.logger.info("Applying Dependency changes to: {}:{}", (Object)project.getGroupId(), (Object)project.getArtifactId());
        List<ProjectRef> dependenciesToRemove = state.getDependencyRemoval();
        boolean result = this.scanDependencies(project.getAllResolvedDependencies(this.session), dependenciesToRemove, model.getDependencies());
        if (model.getDependencyManagement() != null && this.scanDependencies(project.getResolvedManagedDependencies(this.session), dependenciesToRemove, model.getDependencyManagement().getDependencies())) {
            result = true;
        }
        Map<Profile, Map<ArtifactRef, Dependency>> pd = project.getAllResolvedProfileDependencies(this.session);
        Map<Profile, Map<ArtifactRef, Dependency>> pmd = project.getResolvedProfileManagedDependencies(this.session);
        for (Map.Entry<Profile, Map<ArtifactRef, Dependency>> entry : pd.entrySet()) {
            profile = entry.getKey();
            resolvedDependencies = entry.getValue();
            index = model.getProfiles().indexOf(profile);
            if (!this.scanDependencies(resolvedDependencies, dependenciesToRemove, model.getProfiles().get(index).getDependencies())) continue;
            result = true;
        }
        for (Map.Entry<Profile, Map<ArtifactRef, Dependency>> entry : pmd.entrySet()) {
            profile = entry.getKey();
            resolvedDependencies = entry.getValue();
            index = model.getProfiles().indexOf(profile);
            DependencyManagement dm = model.getProfiles().get(index).getDependencyManagement();
            if (dm == null || !this.scanDependencies(resolvedDependencies, dependenciesToRemove, dm.getDependencies())) continue;
            result = true;
        }
        return result;
    }

    private boolean scanDependencies(Map<ArtifactRef, Dependency> resolvedDependencies, List<ProjectRef> dependenciesToRemove, List<Dependency> dependencies) {
        boolean result = false;
        if (dependencies != null) {
            for (Map.Entry<ArtifactRef, Dependency> entry : resolvedDependencies.entrySet()) {
                ArtifactRef pvr = entry.getKey();
                Dependency dependency = entry.getValue();
                if (!dependenciesToRemove.contains(pvr.asProjectRef())) continue;
                this.logger.debug("Removing {}", (Object)dependency);
                dependencies.remove(dependency);
                result = true;
            }
        }
        return result;
    }

    @Override
    public int getExecutionIndex() {
        return 51;
    }
}

