/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core.impl;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPathException;
import com.jayway.jsonpath.Predicate;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.common.model.Project;
import org.commonjava.maven.ext.core.ManipulationSession;
import org.commonjava.maven.ext.core.impl.Manipulator;
import org.commonjava.maven.ext.core.state.JSONState;
import org.commonjava.maven.ext.io.JSONIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="json-manipulator")
@Singleton
public class JSONManipulator
implements Manipulator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final JSONIO jsonIO;
    private ManipulationSession session;

    @Inject
    public JSONManipulator(JSONIO jsonIO) {
        this.jsonIO = jsonIO;
    }

    @Override
    public void init(ManipulationSession session) throws ManipulationException {
        this.session = session;
        session.setState(new JSONState(session.getUserProperties()));
    }

    @Override
    public Set<Project> applyChanges(List<Project> projects) throws ManipulationException {
        JSONState state = this.session.getState(JSONState.class);
        if (!this.session.isEnabled() || !state.isEnabled()) {
            this.logger.debug("{}: Nothing to do!", (Object)this.getClass().getSimpleName());
            return Collections.emptySet();
        }
        HashSet<Project> changed = new HashSet<Project>();
        List<JSONState.JSONOperation> scripts = state.getJSONOperations();
        for (Project project : projects) {
            if (!project.isExecutionRoot()) continue;
            for (JSONState.JSONOperation operation : scripts) {
                this.internalApplyChanges(project, operation);
                changed.add(project);
            }
        }
        return changed;
    }

    void internalApplyChanges(Project project, JSONState.JSONOperation operation) throws ManipulationException {
        File target = new File(project.getPom().getParentFile(), operation.getFile());
        this.logger.info("Attempting to start JSON update to file {} with xpath {} and replacement '{}' ", target, operation.getXPath(), operation.getUpdate());
        DocumentContext dc = null;
        try {
            if (!target.exists()) {
                this.logger.error("Unable to locate JSON file {}", (Object)target);
                throw new ManipulationException("Unable to locate JSON file {}", target);
            }
            dc = this.jsonIO.parseJSON(target);
            List o = (List)dc.read(operation.getXPath(), new Predicate[0]);
            if (o.size() == 0) {
                if (project.isIncrementalPME()) {
                    this.logger.warn("Did not locate JSON using XPath {}", (Object)operation.getXPath());
                    return;
                }
                this.logger.error("XPath {} did not find any expressions within {}", (Object)operation.getXPath(), (Object)operation.getFile());
                throw new ManipulationException("XPath did not resolve to a valid value", new Object[0]);
            }
            if (StringUtils.isEmpty(operation.getUpdate())) {
                this.logger.info("Deleting {} on {}", (Object)operation.getXPath(), (Object)dc);
                dc.delete(operation.getXPath(), new Predicate[0]);
            } else {
                this.logger.info("Updating {} on {}", (Object)operation.getXPath(), (Object)dc);
                dc.set(operation.getXPath(), operation.getUpdate(), new Predicate[0]);
            }
            this.jsonIO.writeJSON(target, dc);
        }
        catch (JsonPathException e) {
            this.logger.error("Caught JSON exception processing file {}, document context {}", target, dc, e);
            throw new ManipulationException("Caught JsonPath", e);
        }
    }

    @Override
    public int getExecutionIndex() {
        return 90;
    }
}

