/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core.impl;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.common.model.Project;
import org.commonjava.maven.ext.core.ManipulationSession;
import org.commonjava.maven.ext.core.groovy.InvocationStage;
import org.commonjava.maven.ext.core.impl.BaseGroovyManipulator;
import org.commonjava.maven.ext.core.state.GroovyState;
import org.commonjava.maven.ext.io.FileIO;
import org.commonjava.maven.ext.io.ModelIO;
import org.commonjava.maven.ext.io.PomIO;

@Named(value="groovy-injection-preparse")
@Singleton
public class PreparseGroovyManipulator
extends BaseGroovyManipulator {
    @Inject
    public PreparseGroovyManipulator(ModelIO modelIO, FileIO fileIO, PomIO pomIO) {
        super(modelIO, fileIO, pomIO);
    }

    public Set<Project> applyChanges(ManipulationSession session) throws ManipulationException {
        this.session = session;
        GroovyState state = new GroovyState(session.getUserProperties());
        session.setState(state);
        if (!session.isEnabled() || !state.isEnabled()) {
            this.logger.debug("{}: Nothing to do!", (Object)this.getClass().getSimpleName());
            return Collections.emptySet();
        }
        List<File> groovyScripts = this.parseGroovyScripts(state.getGroovyScripts());
        for (File groovyScript : groovyScripts) {
            this.applyGroovyScript(Collections.emptyList(), null, groovyScript);
        }
        return Collections.emptySet();
    }

    @Override
    public int getExecutionIndex() {
        return InvocationStage.PREPARSE.getStageValue();
    }
}

