/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core.impl;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang.StringUtils;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.common.model.Project;
import org.commonjava.maven.ext.core.ManipulationSession;
import org.commonjava.maven.ext.core.impl.Manipulator;
import org.commonjava.maven.ext.core.state.XMLState;
import org.commonjava.maven.ext.io.XMLIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Named(value="xml-manipulator")
@Singleton
public class XMLManipulator
implements Manipulator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final XPath xPath;
    private final XMLIO xmlIO;
    private ManipulationSession session;

    @Inject
    public XMLManipulator(XMLIO xmlIO) {
        this.xmlIO = xmlIO;
        this.xPath = xmlIO.getXPath();
    }

    @Override
    public void init(ManipulationSession session) throws ManipulationException {
        this.session = session;
        session.setState(new XMLState(session.getUserProperties()));
    }

    @Override
    public Set<Project> applyChanges(List<Project> projects) throws ManipulationException {
        XMLState state = this.session.getState(XMLState.class);
        if (!this.session.isEnabled() || !state.isEnabled()) {
            this.logger.debug("{}: Nothing to do!", (Object)this.getClass().getSimpleName());
            return Collections.emptySet();
        }
        HashSet<Project> changed = new HashSet<Project>();
        List<XMLState.XMLOperation> scripts = state.getXMLOperations();
        for (Project project : projects) {
            if (!project.isExecutionRoot()) continue;
            for (XMLState.XMLOperation operation : scripts) {
                this.internalApplyChanges(project, operation);
                changed.add(project);
            }
        }
        return changed;
    }

    void internalApplyChanges(Project project, XMLState.XMLOperation operation) throws ManipulationException {
        File target = new File(project.getPom().getParentFile(), operation.getFile());
        this.logger.info("Attempting to start XML update to file {} with xpath {} and replacement {}", target, operation.getXPath(), operation.getUpdate());
        Document doc = this.xmlIO.parseXML(target);
        try {
            NodeList nodeList = (NodeList)this.xPath.evaluate(operation.getXPath(), doc, XPathConstants.NODESET);
            if (nodeList.getLength() == 0) {
                if (project.isIncrementalPME()) {
                    this.logger.warn("Did not locate XML using XPath {}", (Object)operation.getXPath());
                    return;
                }
                this.logger.error("XPath {} did not find any expressions within {}", (Object)operation.getXPath(), (Object)operation.getFile());
                throw new ManipulationException("Did not locate XML using XPath {}", operation.getXPath());
            }
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (StringUtils.isEmpty(operation.getUpdate())) {
                    node.getParentNode().removeChild(node);
                    continue;
                }
                node.setTextContent(operation.getUpdate());
            }
            this.xmlIO.writeXML(target, doc);
        }
        catch (XPathExpressionException e) {
            this.logger.error("Caught XML exception processing file {}, document context {}", target, doc, e);
            throw new ManipulationException("Caught XML exception processing file", e);
        }
    }

    @Override
    public int getExecutionIndex() {
        return 91;
    }
}

