/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core.state;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.commonjava.maven.ext.core.ManipulationSession;
import org.commonjava.maven.ext.core.state.State;
import org.commonjava.maven.ext.io.rest.DefaultTranslator;
import org.commonjava.maven.ext.io.rest.Translator;

public class RESTState
implements State {
    public static final String REST_URL = "restURL";
    public static final String REST_BREW_PULL_ACTIVE = "restBrewPullActive";
    public static final String REST_MODE = "restMode";
    public static final String REST_MAX_SIZE = "restMaxSize";
    public static final String REST_MIN_SIZE = "restMinSize";
    public static final String REST_SUFFIX = "restSuffixAlign";
    public static final String REST_HEADERS = "restHeaders";
    public static final String REST_CONNECTION_TIMEOUT_SEC = "restConnectionTimeout";
    public static final String REST_SOCKET_TIMEOUT_SEC = "restSocketTimeout";
    public static final String REST_RETRY_DURATION_SEC = "restRetryDuration";
    private final ManipulationSession session;
    private String restURL;
    private Translator restEndpoint;
    private boolean restSuffixAlign;

    public RESTState(ManipulationSession session) {
        this.session = session;
        this.initialise(session.getUserProperties());
    }

    @Override
    public void initialise(Properties userProps) {
        this.restURL = userProps.getProperty(REST_URL);
        this.restSuffixAlign = Boolean.parseBoolean(userProps.getProperty(REST_SUFFIX, "true"));
        Boolean brewPullActive = Boolean.parseBoolean(userProps.getProperty(REST_BREW_PULL_ACTIVE));
        String mode = userProps.getProperty(REST_MODE, "");
        int restMaxSize = Integer.parseInt(userProps.getProperty(REST_MAX_SIZE, "-1"));
        int restMinSize = Integer.parseInt(userProps.getProperty(REST_MIN_SIZE, String.valueOf(4)));
        Map<String, String> restHeaders = RESTState.restHeaderParser(userProps.getProperty(REST_HEADERS, ""));
        int restConnectionTimeout = Integer.parseInt(userProps.getProperty(REST_CONNECTION_TIMEOUT_SEC, String.valueOf(30)));
        int restSocketTimeout = Integer.parseInt(userProps.getProperty(REST_SOCKET_TIMEOUT_SEC, String.valueOf(600)));
        int restRetryDuration = Integer.parseInt(userProps.getProperty(REST_RETRY_DURATION_SEC, String.valueOf(30)));
        this.restEndpoint = new DefaultTranslator(this.restURL, restMaxSize, restMinSize, brewPullActive, mode, restHeaders, restConnectionTimeout, restSocketTimeout, restRetryDuration);
    }

    @Override
    public boolean isEnabled() {
        return this.restURL != null && !this.restURL.isEmpty();
    }

    public Translator getVersionTranslator() {
        return this.restEndpoint;
    }

    public boolean isRestSuffixAlign() {
        return this.restSuffixAlign;
    }

    public static Map<String, String> restHeaderParser(String value) {
        if (!StringUtils.isEmpty(value)) {
            return Arrays.stream(value.split(",")).map(h -> h.split(":", 2)).filter(h -> ((String[])h).length > 0 && StringUtils.isNotEmpty(h[0])).collect(Collectors.toMap(h -> h[0], h -> ((String[])h).length > 1 ? h[1] : "", (x, y) -> y, LinkedHashMap::new));
        }
        return Collections.emptyMap();
    }
}

