/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core.util;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.ConfigurationContainer;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.common.model.Project;
import org.commonjava.maven.ext.core.ManipulationSession;
import org.commonjava.maven.ext.core.util.PluginReference;
import org.commonjava.maven.ext.core.util.PropertiesUtils;
import org.commonjava.maven.ext.io.resolver.GalleyAPIWrapper;
import org.commonjava.maven.galley.maven.parse.GalleyMavenXMLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DependencyPluginUtils {
    private static final Logger logger = LoggerFactory.getLogger(DependencyPluginUtils.class);

    public static void updateString(Project project, ManipulationSession session, String originalValue, ProjectVersionRef originalRelocation, String relocation, Consumer<String> c) throws ManipulationException {
        if (StringUtils.contains(originalValue, "$")) {
            if (StringUtils.countMatches(originalValue = originalValue.substring(2, originalValue.length() - 1), "${") > 1) {
                throw new ManipulationException("Relocations with multiple embedded version properties not supported", new Object[0]);
            }
            logger.debug("Updating relocation for {} with property {} to new value {}", originalRelocation, originalValue, relocation);
            PropertiesUtils.updateProperties(session, project, true, originalValue, relocation);
        } else {
            c.accept(relocation);
        }
    }

    private static PluginReference findPluginReference(GalleyAPIWrapper galleyWrapper, ConfigurationContainer container, Node parent) {
        if (parent == null) {
            return null;
        }
        NodeList children = parent.getChildNodes();
        int length = children.getLength();
        logger.debug("Update child nodes for {} with {} children", (Object)parent.getNodeName(), (Object)length);
        Node groupIdNode = null;
        Node artifactIdNode = null;
        Node versionNode = null;
        block10: for (int i = 0; i < length; ++i) {
            Node node = children.item(i);
            switch (node.getNodeName()) {
                case "groupId": {
                    groupIdNode = node;
                    continue block10;
                }
                case "artifactId": {
                    artifactIdNode = node;
                    continue block10;
                }
                case "version": {
                    versionNode = node;
                }
            }
        }
        if (groupIdNode != null && artifactIdNode != null) {
            PluginReference ref = new PluginReference(galleyWrapper, container, groupIdNode, artifactIdNode, versionNode);
            logger.debug("Found plugin reference: {}", (Object)ref);
            return ref;
        }
        return null;
    }

    private static List<PluginReference> findPluginReferences(GalleyAPIWrapper galleyWrapper, Map.Entry<ConfigurationContainer, String> entry, NodeList children) {
        int length = children.getLength();
        logger.debug("Got {} children to update plugin GAVs", (Object)length);
        ArrayList<PluginReference> refs = new ArrayList<PluginReference>(length);
        for (int i = 0; i < length; ++i) {
            Node node = children.item(i);
            logger.debug("Child name is {} and text content is {}", (Object)node.getNodeName(), (Object)node.getTextContent());
            PluginReference ref = DependencyPluginUtils.findPluginReference(galleyWrapper, entry.getKey(), node);
            if (ref == null) continue;
            refs.add(ref);
        }
        return refs;
    }

    public static List<PluginReference> findPluginReferences(GalleyAPIWrapper galleyWrapper, Project project, Map<ProjectVersionRef, Plugin> pluginMap) throws ManipulationException {
        Collection<Plugin> plugins = pluginMap.values();
        ArrayList<PluginReference> refs = new ArrayList<PluginReference>();
        for (Plugin plugin : plugins) {
            Map<ConfigurationContainer, String> configs = DependencyPluginUtils.findConfigurations(plugin);
            logger.debug("Found {} configs for plugin {}:{}:{}", configs.size(), plugin.getGroupId(), plugin.getArtifactId(), plugin.getVersion());
            for (Map.Entry<ConfigurationContainer, String> entry : configs.entrySet()) {
                try {
                    Document doc = galleyWrapper.parseXml(entry.getValue());
                    XPath xPath = XPathFactory.newInstance().newXPath();
                    PluginReference ref = DependencyPluginUtils.findPluginReference(galleyWrapper, entry.getKey(), doc.getFirstChild());
                    if (ref != null) {
                        refs.add(ref);
                    }
                    NodeList artifactItems = (NodeList)xPath.evaluate(".//artifactItems/*", doc, XPathConstants.NODESET);
                    List<PluginReference> artifactItemRefs = DependencyPluginUtils.findPluginReferences(galleyWrapper, entry, artifactItems);
                    refs.addAll(artifactItemRefs);
                }
                catch (GalleyMavenXMLException e) {
                    throw new ManipulationException("Unable to parse config for plugin {} in {}", plugin.getId(), project.getKey(), e);
                }
                catch (XPathExpressionException e) {
                    throw new ManipulationException("Invalid XPath expression for plugin {} in {}", plugin.getId(), project.getKey(), e);
                }
            }
        }
        return refs;
    }

    private static Map<ConfigurationContainer, String> findConfigurations(Plugin plugin) {
        List<PluginExecution> executions;
        if (plugin == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<ConfigurationContainer, String> configs = new LinkedHashMap<ConfigurationContainer, String>();
        Object pluginConfiguration = plugin.getConfiguration();
        if (pluginConfiguration != null) {
            configs.put(plugin, pluginConfiguration.toString());
        }
        if ((executions = plugin.getExecutions()) != null) {
            for (PluginExecution execution : executions) {
                Object executionConfiguration = execution.getConfiguration();
                if (executionConfiguration == null) continue;
                configs.put(execution, executionConfiguration.toString());
            }
        }
        return configs;
    }

    public static Xpp3Dom getConfigXml(GalleyAPIWrapper galleyWrapper, Node node) throws ManipulationException {
        String config = galleyWrapper.toXML(node.getOwnerDocument(), false).trim();
        try {
            return Xpp3DomBuilder.build(new StringReader(config));
        }
        catch (IOException | XmlPullParserException e) {
            throw new ManipulationException("Failed to re-parse plugin configuration into Xpp3Dom: {}. Config was: {}", e.getMessage(), config, e);
        }
    }

    private DependencyPluginUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

