/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core.util;

import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.InputLocationTracker;
import org.apache.maven.model.Plugin;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.core.util.PluginReference;

public class DependencyPluginWrapper {
    private Plugin plugin = null;
    private Dependency dependency = null;
    private PluginReference pluginReference = null;

    public DependencyPluginWrapper(InputLocationTracker o) throws ManipulationException {
        if (o instanceof Dependency) {
            this.dependency = (Dependency)o;
        } else if (o instanceof Plugin) {
            this.plugin = (Plugin)o;
        } else if (o instanceof PluginReference) {
            this.pluginReference = (PluginReference)o;
        } else {
            throw new ManipulationException("Unknown type for wrapper {}", o);
        }
    }

    public String getVersion() {
        if (this.dependency != null) {
            return this.dependency.getVersion();
        }
        if (this.plugin != null) {
            return this.plugin.getVersion();
        }
        return this.pluginReference.getVersion();
    }

    public void setVersion(String target) throws ManipulationException {
        if (this.dependency != null) {
            this.dependency.setVersion(target);
        } else if (this.plugin != null) {
            this.plugin.setVersion(target);
        } else {
            this.pluginReference.setVersion(target);
        }
    }

    public void addExclusion(Exclusion e) throws ManipulationException {
        if (this.dependency == null) {
            throw new ManipulationException("Type is not a dependency {}", e);
        }
        this.dependency.addExclusion(e);
    }
}

