/*
 * Decompiled with CFR 0.152.
 */
package org.goots.hiderdoclet.doclet;

import javax.lang.model.SourceVersion;
import jdk.javadoc.doclet.DocletEnvironment;
import jdk.javadoc.doclet.StandardDoclet;
import org.goots.hiderdoclet.doclet.DocletEnvironmentProcessor;
import org.goots.logback.classic.Level;
import org.goots.logback.classic.Logger;
import org.goots.logback.classic.LoggerContext;
import org.goots.logback.classic.encoder.PatternLayoutEncoder;
import org.goots.logback.classic.spi.ILoggingEvent;
import org.goots.logback.core.Appender;
import org.goots.logback.core.ConsoleAppender;
import org.goots.slf4j.LoggerFactory;

public class JavadocFilter
extends StandardDoclet {
    public JavadocFilter() {
        Logger root = (Logger)LoggerFactory.getLogger("ROOT");
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        loggerContext.reset();
        PatternLayoutEncoder ple = new PatternLayoutEncoder();
        ple.setPattern("[%level] %logger{36} - %msg%n");
        ple.setContext(loggerContext);
        ple.start();
        ConsoleAppender<ILoggingEvent> consoleAppender = new ConsoleAppender<ILoggingEvent>();
        consoleAppender.setEncoder(ple);
        consoleAppender.setContext(loggerContext);
        consoleAppender.start();
        root.addAppender((Appender<ILoggingEvent>)consoleAppender);
        String logLevel = System.getProperty("org.goots.hiderdoclet.logLevel", "info");
        if ("debug".equalsIgnoreCase(logLevel)) {
            root.setLevel(Level.DEBUG);
        } else if ("warn".equalsIgnoreCase(logLevel)) {
            root.setLevel(Level.WARN);
        } else if ("info".equalsIgnoreCase(logLevel)) {
            root.setLevel(Level.INFO);
        }
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.RELEASE_11;
    }

    @Override
    public boolean run(DocletEnvironment environment) {
        return super.run(new DocletEnvironmentProcessor(environment));
    }
}

