/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.da.reports.model.response;

import com.fasterxml.jackson.annotation.JsonUnwrapped;
import java.util.List;
import lombok.NonNull;
import org.jboss.da.listings.model.rest.RestProductInput;
import org.jboss.da.model.rest.GAV;

public class LookupReport {
    @JsonUnwrapped
    @NonNull
    private GAV gav;
    private String bestMatchVersion;
    private List<String> availableVersions;
    private boolean blacklisted;
    private List<RestProductInput> whitelisted;

    public LookupReport(GAV gav) {
        this.gav = gav;
    }

    @NonNull
    public GAV getGav() {
        return this.gav;
    }

    public String getBestMatchVersion() {
        return this.bestMatchVersion;
    }

    public List<String> getAvailableVersions() {
        return this.availableVersions;
    }

    public boolean isBlacklisted() {
        return this.blacklisted;
    }

    public List<RestProductInput> getWhitelisted() {
        return this.whitelisted;
    }

    public void setGav(@NonNull GAV gav) {
        if (gav == null) {
            throw new NullPointerException("gav is marked non-null but is null");
        }
        this.gav = gav;
    }

    public void setBestMatchVersion(String bestMatchVersion) {
        this.bestMatchVersion = bestMatchVersion;
    }

    public void setAvailableVersions(List<String> availableVersions) {
        this.availableVersions = availableVersions;
    }

    public void setBlacklisted(boolean blacklisted) {
        this.blacklisted = blacklisted;
    }

    public void setWhitelisted(List<RestProductInput> whitelisted) {
        this.whitelisted = whitelisted;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LookupReport)) {
            return false;
        }
        LookupReport other = (LookupReport)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isBlacklisted() != other.isBlacklisted()) {
            return false;
        }
        GAV this$gav = this.getGav();
        GAV other$gav = other.getGav();
        if (this$gav == null ? other$gav != null : !((Object)this$gav).equals(other$gav)) {
            return false;
        }
        String this$bestMatchVersion = this.getBestMatchVersion();
        String other$bestMatchVersion = other.getBestMatchVersion();
        if (this$bestMatchVersion == null ? other$bestMatchVersion != null : !this$bestMatchVersion.equals(other$bestMatchVersion)) {
            return false;
        }
        List<String> this$availableVersions = this.getAvailableVersions();
        List<String> other$availableVersions = other.getAvailableVersions();
        if (this$availableVersions == null ? other$availableVersions != null : !((Object)this$availableVersions).equals(other$availableVersions)) {
            return false;
        }
        List<RestProductInput> this$whitelisted = this.getWhitelisted();
        List<RestProductInput> other$whitelisted = other.getWhitelisted();
        return !(this$whitelisted == null ? other$whitelisted != null : !((Object)this$whitelisted).equals(other$whitelisted));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LookupReport;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isBlacklisted() ? 79 : 97);
        GAV $gav = this.getGav();
        result = result * 59 + ($gav == null ? 43 : ((Object)$gav).hashCode());
        String $bestMatchVersion = this.getBestMatchVersion();
        result = result * 59 + ($bestMatchVersion == null ? 43 : $bestMatchVersion.hashCode());
        List<String> $availableVersions = this.getAvailableVersions();
        result = result * 59 + ($availableVersions == null ? 43 : ((Object)$availableVersions).hashCode());
        List<RestProductInput> $whitelisted = this.getWhitelisted();
        result = result * 59 + ($whitelisted == null ? 43 : ((Object)$whitelisted).hashCode());
        return result;
    }

    public String toString() {
        return "LookupReport(gav=" + this.getGav() + ", bestMatchVersion=" + this.getBestMatchVersion() + ", availableVersions=" + this.getAvailableVersions() + ", blacklisted=" + this.isBlacklisted() + ", whitelisted=" + this.getWhitelisted() + ")";
    }

    public LookupReport(@NonNull GAV gav, String bestMatchVersion, List<String> availableVersions, boolean blacklisted, List<RestProductInput> whitelisted) {
        if (gav == null) {
            throw new NullPointerException("gav is marked non-null but is null");
        }
        this.gav = gav;
        this.bestMatchVersion = bestMatchVersion;
        this.availableVersions = availableVersions;
        this.blacklisted = blacklisted;
        this.whitelisted = whitelisted;
    }

    public LookupReport() {
    }
}

