/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.testing.maven;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.commonjava.maven.galley.GalleyInitException;
import org.commonjava.maven.galley.TransferManager;
import org.commonjava.maven.galley.cache.CacheProviderFactory;
import org.commonjava.maven.galley.cache.FileCacheProvider;
import org.commonjava.maven.galley.cache.FileCacheProviderFactory;
import org.commonjava.maven.galley.io.TransferDecoratorManager;
import org.commonjava.maven.galley.maven.ArtifactManager;
import org.commonjava.maven.galley.maven.ArtifactMetadataManager;
import org.commonjava.maven.galley.maven.GalleyMaven;
import org.commonjava.maven.galley.maven.GalleyMavenBuilder;
import org.commonjava.maven.galley.maven.internal.type.StandardTypeMapper;
import org.commonjava.maven.galley.maven.internal.version.VersionResolverImpl;
import org.commonjava.maven.galley.maven.model.view.XPathManager;
import org.commonjava.maven.galley.maven.parse.MavenMetadataReader;
import org.commonjava.maven.galley.maven.parse.MavenPomReader;
import org.commonjava.maven.galley.maven.parse.XMLInfrastructure;
import org.commonjava.maven.galley.maven.spi.defaults.MavenPluginDefaults;
import org.commonjava.maven.galley.maven.spi.defaults.MavenPluginImplications;
import org.commonjava.maven.galley.maven.spi.type.TypeMapper;
import org.commonjava.maven.galley.maven.spi.version.VersionResolver;
import org.commonjava.maven.galley.spi.auth.PasswordManager;
import org.commonjava.maven.galley.spi.cache.CacheProvider;
import org.commonjava.maven.galley.spi.event.FileEventManager;
import org.commonjava.maven.galley.spi.nfc.NotFoundCache;
import org.commonjava.maven.galley.spi.transport.LocationExpander;
import org.commonjava.maven.galley.spi.transport.LocationResolver;
import org.commonjava.maven.galley.spi.transport.Transport;
import org.commonjava.maven.galley.spi.transport.TransportManager;
import org.commonjava.maven.galley.testing.core.cache.TestCacheProvider;
import org.commonjava.maven.galley.testing.core.transport.TestTransport;
import org.junit.rules.ExternalResource;
import org.junit.rules.TemporaryFolder;

public class GalleyMavenFixture
extends ExternalResource {
    private GalleyMavenBuilder mavenBuilder;
    private GalleyMaven maven;
    private TemporaryFolder temp;
    private TestTransport testTransport;
    private Transport[] extraTransports;
    private final boolean autoInit;
    private File cacheDir;

    public GalleyMavenFixture(TemporaryFolder temp) {
        this.autoInit = true;
        this.temp = temp;
    }

    public GalleyMavenFixture(boolean autoInit, TemporaryFolder temp) {
        this.autoInit = autoInit;
        this.temp = temp;
    }

    public GalleyMavenFixture(boolean autoInit) {
        this.autoInit = autoInit;
    }

    public GalleyMavenFixture() {
        this.autoInit = true;
    }

    public void initGalley() throws IOException {
        if (this.temp == null) {
            this.temp = new TemporaryFolder();
        }
        this.temp.create();
        if (this.cacheDir == null) {
            this.cacheDir = this.temp.newFolder(new String[]{"cache"});
        }
        this.mavenBuilder = new GalleyMavenBuilder();
        this.mavenBuilder.withCacheProviderFactory((CacheProviderFactory)new FileCacheProviderFactory(this.cacheDir));
    }

    public GalleyMaven getGalleyMaven() throws GalleyInitException {
        if (this.maven == null) {
            this.maven = this.mavenBuilder.build();
        }
        return this.maven;
    }

    public void initTestTransport() {
        this.testTransport = new TestTransport();
        this.mavenBuilder.withAdditionalTransport((Transport)this.testTransport);
    }

    public void initMissingComponents() throws Exception {
        List transports;
        if (this.mavenBuilder == null) {
            this.initGalley();
        }
        if ((transports = this.mavenBuilder.getEnabledTransports()) == null || transports.isEmpty()) {
            this.initTestTransport();
        }
        this.mavenBuilder.initMissingComponents();
    }

    public void before() throws Throwable {
        if (this.autoInit && this.maven == null) {
            this.initMissingComponents();
            if (this.mavenBuilder.getCacheProviderFactory() == null && this.mavenBuilder.getCache() == null && this.temp != null && this.cacheDir == null) {
                this.cacheDir = this.temp.newFolder(new String[]{"cache"});
            }
            this.mavenBuilder.withCache((CacheProvider)new FileCacheProvider(this.cacheDir, this.mavenBuilder.getPathGenerator(), this.mavenBuilder.getFileEvents(), this.mavenBuilder.getTransferDecorator()));
            this.maven = this.mavenBuilder.build();
        }
        super.before();
    }

    public void after() {
        this.maven = null;
        super.after();
    }

    private void checkInitialized() {
        if (this.maven != null) {
            throw new IllegalStateException("Already initialized!");
        }
    }

    public Transport[] getExtraTransports() {
        return this.extraTransports;
    }

    public GalleyMavenFixture withExtraTransports(Transport ... transports) {
        this.checkInitialized();
        this.extraTransports = transports;
        for (Transport transport : transports) {
            this.mavenBuilder.withAdditionalTransport(transport);
        }
        return this;
    }

    public TestTransport getTransport() {
        return this.testTransport;
    }

    public NotFoundCache getNfc() {
        return this.maven == null ? this.mavenBuilder.getNfc() : this.mavenBuilder.getNfc();
    }

    public TemporaryFolder getTemp() {
        return this.temp;
    }

    public GalleyMavenFixture withTemp(TemporaryFolder temp) {
        if (this.temp != null) {
            this.temp.delete();
        }
        this.temp = temp;
        return this;
    }

    @Deprecated
    public GalleyMavenFixture setTemp(TemporaryFolder temp) {
        if (this.temp != null) {
            this.temp.delete();
        }
        this.temp = temp;
        return this;
    }

    @Deprecated
    public GalleyMavenFixture setExtraTransports(Transport ... transports) {
        this.checkInitialized();
        this.extraTransports = transports;
        for (Transport transport : transports) {
            this.mavenBuilder.withAdditionalTransport(transport);
        }
        return this;
    }

    @Deprecated
    public ArtifactManager getArtifacts() {
        return this.maven == null ? this.mavenBuilder.getArtifactManager() : this.mavenBuilder.getArtifactManager();
    }

    @Deprecated
    public ArtifactMetadataManager getMetadata() {
        return this.maven == null ? this.mavenBuilder.getArtifactMetadataManager() : this.mavenBuilder.getArtifactMetadataManager();
    }

    @Deprecated
    public GalleyMavenFixture setArtifacts(ArtifactManager artifacts) {
        this.checkInitialized();
        this.mavenBuilder.withArtifactManager(artifacts);
        return this;
    }

    @Deprecated
    public GalleyMavenFixture setMetadata(ArtifactMetadataManager metadata) {
        this.checkInitialized();
        this.mavenBuilder.withArtifactMetadataManager(metadata);
        return this;
    }

    @Deprecated
    public TypeMapper getMapper() {
        return this.maven == null ? this.mavenBuilder.getTypeMapper() : this.maven.getTypeMapper();
    }

    @Deprecated
    public GalleyMavenFixture setMapper(StandardTypeMapper mapper) {
        this.checkInitialized();
        this.mavenBuilder.withTypeMapper((TypeMapper)mapper);
        return this;
    }

    @Deprecated
    public GalleyMavenFixture setPomReader(MavenPomReader pomReader) {
        this.checkInitialized();
        this.mavenBuilder.withPomReader(pomReader);
        return this;
    }

    @Deprecated
    public GalleyMavenFixture setXpathManager(XPathManager xpathManager) {
        this.checkInitialized();
        this.mavenBuilder.withXPathManager(xpathManager);
        return this;
    }

    @Deprecated
    public LocationExpander getLocations() {
        return this.maven == null ? this.mavenBuilder.getLocationExpander() : this.mavenBuilder.getLocationExpander();
    }

    @Deprecated
    public TransferDecoratorManager getDecorator() {
        return this.maven == null ? this.mavenBuilder.getTransferDecorator() : this.mavenBuilder.getTransferDecorator();
    }

    @Deprecated
    public FileEventManager getEvents() {
        return this.maven == null ? this.mavenBuilder.getFileEvents() : this.mavenBuilder.getFileEvents();
    }

    @Deprecated
    public GalleyMavenFixture setLocations(LocationExpander locations) {
        this.checkInitialized();
        this.mavenBuilder.withLocationExpander(locations);
        return this;
    }

    @Deprecated
    public GalleyMavenFixture setDecorator(TransferDecoratorManager decorator) {
        this.checkInitialized();
        this.mavenBuilder.withTransferDecorator(decorator);
        return this;
    }

    @Deprecated
    public GalleyMavenFixture setEvents(FileEventManager events) {
        this.checkInitialized();
        this.mavenBuilder.withFileEvents(events);
        return this;
    }

    @Deprecated
    public GalleyMavenFixture setCache(TestCacheProvider cache) {
        this.checkInitialized();
        this.mavenBuilder.withCache((CacheProvider)cache);
        return this;
    }

    @Deprecated
    public GalleyMavenFixture setTransport(TestTransport transport) {
        this.testTransport = transport;
        return this;
    }

    @Deprecated
    public GalleyMavenFixture setNfc(NotFoundCache nfc) {
        this.checkInitialized();
        this.mavenBuilder.withNfc(nfc);
        return this;
    }

    @Deprecated
    public TransportManager getTransports() {
        return this.maven == null ? this.mavenBuilder.getTransportManager() : this.mavenBuilder.getTransportManager();
    }

    @Deprecated
    public TransferManager getTransfers() {
        return this.maven == null ? this.mavenBuilder.getTransferManager() : this.mavenBuilder.getTransferManager();
    }

    @Deprecated
    public GalleyMavenFixture setTransports(TransportManager transports) {
        this.checkInitialized();
        this.mavenBuilder.withTransportManager(transports);
        return this;
    }

    @Deprecated
    public GalleyMavenFixture setTransfers(TransferManager transfers) {
        this.checkInitialized();
        this.mavenBuilder.withTransferManager(transfers);
        return this;
    }

    @Deprecated
    public XMLInfrastructure getXmlInfra() {
        return this.maven == null ? this.mavenBuilder.getXmlInfrastructure() : this.mavenBuilder.getXmlInfrastructure();
    }

    @Deprecated
    public GalleyMavenFixture setXmlInfra(XMLInfrastructure xmlInfra) {
        this.checkInitialized();
        this.mavenBuilder.withXmlInfrastructure(xmlInfra);
        return this;
    }

    @Deprecated
    public GalleyMavenFixture setMapper(TypeMapper mapper) {
        this.checkInitialized();
        this.mavenBuilder.withTypeMapper(mapper);
        return this;
    }

    @Deprecated
    public GalleyMavenFixture setPluginDefaults(MavenPluginDefaults pluginDefaults) {
        this.checkInitialized();
        this.mavenBuilder.withPluginDefaults(pluginDefaults);
        return this;
    }

    @Deprecated
    public GalleyMavenFixture setPluginImplications(MavenPluginImplications pluginImplications) {
        this.checkInitialized();
        this.mavenBuilder.withPluginImplications(pluginImplications);
        return this;
    }

    @Deprecated
    public MavenMetadataReader getMetaReader() {
        return this.maven == null ? this.mavenBuilder.getMavenMetadataReader() : this.mavenBuilder.getMavenMetadataReader();
    }

    @Deprecated
    public VersionResolver getVersions() {
        return this.maven == null ? this.mavenBuilder.getVersionResolver() : this.mavenBuilder.getVersionResolver();
    }

    @Deprecated
    public GalleyMavenFixture setMetaReader(MavenMetadataReader metaReader) {
        this.checkInitialized();
        this.mavenBuilder.withMavenMetadataReader(metaReader);
        return this;
    }

    @Deprecated
    public GalleyMavenFixture setVersions(VersionResolverImpl versions) {
        this.checkInitialized();
        this.mavenBuilder.withVersionResolver((VersionResolver)versions);
        return this;
    }

    public ArtifactManager getArtifactManager() {
        return this.maven == null ? this.mavenBuilder.getArtifactManager() : this.maven.getArtifactManager();
    }

    public ArtifactMetadataManager getArtifactMetadataManager() {
        return this.maven == null ? this.mavenBuilder.getArtifactMetadataManager() : this.maven.getArtifactMetadataManager();
    }

    public TypeMapper getTypeMapper() {
        return this.maven == null ? this.mavenBuilder.getTypeMapper() : this.maven.getTypeMapper();
    }

    public MavenPomReader getPomReader() {
        return this.maven == null ? this.mavenBuilder.getPomReader() : this.maven.getPomReader();
    }

    public MavenPluginDefaults getPluginDefaults() {
        return this.maven == null ? this.mavenBuilder.getPluginDefaults() : this.maven.getPluginDefaults();
    }

    public XPathManager getXPathManager() {
        return this.maven == null ? this.mavenBuilder.getXPathManager() : this.maven.getXPathManager();
    }

    public XMLInfrastructure getXmlInfrastructure() {
        return this.maven == null ? this.mavenBuilder.getXmlInfrastructure() : this.maven.getXmlInfrastructure();
    }

    public MavenPluginImplications getPluginImplications() {
        return this.maven == null ? this.mavenBuilder.getPluginImplications() : this.maven.getPluginImplications();
    }

    public MavenMetadataReader getMavenMetadataReader() {
        return this.maven == null ? this.mavenBuilder.getMavenMetadataReader() : this.maven.getMavenMetadataReader();
    }

    public VersionResolver getVersionResolver() {
        return this.maven == null ? this.mavenBuilder.getVersionResolver() : this.maven.getVersionResolver();
    }

    public LocationExpander getLocationExpander() {
        return this.maven == null ? this.mavenBuilder.getLocationExpander() : this.maven.getLocationExpander();
    }

    public LocationResolver getLocationResolver() {
        return this.maven == null ? this.mavenBuilder.getLocationResolver() : this.maven.getLocationResolver();
    }

    public TransferDecoratorManager getTransferDecorator() {
        return this.maven == null ? this.mavenBuilder.getTransferDecorator() : this.maven.getTransferDecorator();
    }

    public FileEventManager getFileEvents() {
        return this.maven == null ? this.mavenBuilder.getFileEvents() : this.maven.getFileEvents();
    }

    public CacheProvider getCache() {
        return this.maven == null ? this.mavenBuilder.getCache() : this.maven.getCache();
    }

    public TransportManager getTransportManager() {
        return this.maven == null ? this.mavenBuilder.getTransportManager() : this.maven.getTransportManager();
    }

    public TransferManager getTransferManager() {
        return this.maven == null ? this.mavenBuilder.getTransferManager() : this.maven.getTransferManager();
    }

    public List<Transport> getEnabledTransports() {
        return this.maven == null ? this.mavenBuilder.getEnabledTransports() : this.maven.getEnabledTransports();
    }

    public ExecutorService getHandlerExecutor() {
        return this.maven == null ? this.mavenBuilder.getHandlerExecutor() : this.maven.getHandlerExecutor();
    }

    public ExecutorService getBatchExecutor() {
        return this.maven == null ? this.mavenBuilder.getBatchExecutor() : this.maven.getBatchExecutor();
    }

    public PasswordManager getPasswordManager() {
        return this.maven == null ? this.mavenBuilder.getPasswordManager() : this.maven.getPasswordManager();
    }

    public GalleyMavenFixture withArtifactManager(ArtifactManager artifactManager) {
        this.checkInitialized();
        this.mavenBuilder.withArtifactManager(artifactManager);
        return this;
    }

    public GalleyMavenFixture withArtifactMetadataManager(ArtifactMetadataManager metadata) {
        this.checkInitialized();
        this.mavenBuilder.withArtifactMetadataManager(metadata);
        return this;
    }

    public GalleyMavenFixture withPomReader(MavenPomReader pomReader) {
        this.checkInitialized();
        this.mavenBuilder.withPomReader(pomReader);
        return this;
    }

    public GalleyMavenFixture withXPathManager(XPathManager xpathManager) {
        this.checkInitialized();
        this.mavenBuilder.withXPathManager(xpathManager);
        return this;
    }

    public GalleyMavenFixture withXmlInfrastructure(XMLInfrastructure xmlInfra) {
        this.checkInitialized();
        this.mavenBuilder.withXmlInfrastructure(xmlInfra);
        return this;
    }

    public GalleyMavenFixture withTypeMapper(TypeMapper mapper) {
        this.checkInitialized();
        this.mavenBuilder.withTypeMapper(mapper);
        return this;
    }

    public GalleyMavenFixture withPluginDefaults(MavenPluginDefaults pluginDefaults) {
        this.checkInitialized();
        this.mavenBuilder.withPluginDefaults(pluginDefaults);
        return this;
    }

    public GalleyMavenFixture withPluginImplications(MavenPluginImplications pluginImplications) {
        this.checkInitialized();
        this.mavenBuilder.withPluginImplications(pluginImplications);
        return this;
    }

    public GalleyMavenFixture withMavenMetadataReader(MavenMetadataReader metaReader) {
        this.checkInitialized();
        this.mavenBuilder.withMavenMetadataReader(metaReader);
        return this;
    }

    public GalleyMavenFixture withVersionResolver(VersionResolver versionResolver) {
        this.checkInitialized();
        this.mavenBuilder.withVersionResolver(versionResolver);
        return this;
    }

    public GalleyMavenFixture withLocationExpander(LocationExpander locationExpander) {
        this.checkInitialized();
        this.mavenBuilder.withLocationExpander(locationExpander);
        return this;
    }

    public GalleyMavenFixture withLocationResolver(LocationResolver locationResolver) {
        this.checkInitialized();
        this.mavenBuilder.withLocationResolver(locationResolver);
        return this;
    }

    public GalleyMavenFixture withTransferDecorator(TransferDecoratorManager decorator) {
        this.checkInitialized();
        this.mavenBuilder.withTransferDecorator(decorator);
        return this;
    }

    public GalleyMavenFixture withFileEvents(FileEventManager events) {
        this.checkInitialized();
        this.mavenBuilder.withFileEvents(events);
        return this;
    }

    public GalleyMavenFixture withCache(CacheProvider cache) {
        this.checkInitialized();
        this.mavenBuilder.withCache(cache);
        return this;
    }

    public GalleyMavenFixture withNfc(NotFoundCache nfc) {
        this.checkInitialized();
        this.mavenBuilder.withNfc(nfc);
        return this;
    }

    public GalleyMavenFixture withTransportManager(TransportManager transportManager) {
        this.checkInitialized();
        this.mavenBuilder.withTransportManager(transportManager);
        return this;
    }

    public GalleyMavenFixture withTransferManager(TransferManager transferManager) {
        this.checkInitialized();
        this.mavenBuilder.withTransferManager(transferManager);
        return this;
    }

    public GalleyMavenFixture withEnabledTransports(List<Transport> transports) {
        this.checkInitialized();
        this.mavenBuilder.withEnabledTransports(transports);
        return this;
    }

    public GalleyMavenFixture withEnabledTransports(Transport ... transports) {
        this.checkInitialized();
        this.mavenBuilder.withEnabledTransports(transports);
        return this;
    }

    public GalleyMavenFixture withHandlerExecutor(ExecutorService handlerExecutor) {
        this.checkInitialized();
        this.mavenBuilder.withHandlerExecutor(handlerExecutor);
        return this;
    }

    public GalleyMavenFixture withBatchExecutor(ExecutorService batchExecutor) {
        this.checkInitialized();
        this.mavenBuilder.withBatchExecutor(batchExecutor);
        return this;
    }

    public GalleyMavenFixture withPasswordManager(PasswordManager passwordManager) {
        this.checkInitialized();
        this.mavenBuilder.withPasswordManager(passwordManager);
        return this;
    }

    public GalleyMavenFixture withAdditionalTransport(Transport transport) {
        this.checkInitialized();
        this.mavenBuilder.withAdditionalTransport(transport);
        return this;
    }

    public GalleyMavenFixture withCacheProviderFactory(CacheProviderFactory cacheProviderFactory) {
        this.mavenBuilder.withCacheProviderFactory(cacheProviderFactory);
        return this;
    }

    public CacheProviderFactory getCacheProviderFactory() {
        return this.mavenBuilder.getCacheProviderFactory();
    }

    @Deprecated
    public XPathManager getXpathManager() {
        return this.getXPathManager();
    }
}

