/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.sqs.config;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSClientBuilder;
import com.netflix.conductor.core.config.ConductorProperties;
import com.netflix.conductor.core.events.EventQueueProvider;
import com.netflix.conductor.core.events.queue.ObservableQueue;
import com.netflix.conductor.model.TaskModel;
import com.netflix.conductor.sqs.config.SQSEventQueueProperties;
import com.netflix.conductor.sqs.config.SQSEventQueueProvider;
import com.netflix.conductor.sqs.eventqueue.SQSObservableQueue;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import rx.Scheduler;

@Configuration
@EnableConfigurationProperties(value={SQSEventQueueProperties.class})
@ConditionalOnProperty(name={"conductor.event-queues.sqs.enabled"}, havingValue="true")
public class SQSEventQueueConfiguration {
    @Autowired
    private SQSEventQueueProperties sqsProperties;
    private static final Logger LOGGER = LoggerFactory.getLogger(SQSEventQueueConfiguration.class);

    @Bean
    AWSCredentialsProvider createAWSCredentialsProvider() {
        return new DefaultAWSCredentialsProviderChain();
    }

    @ConditionalOnMissingBean
    @Bean
    public AmazonSQS getSQSClient(AWSCredentialsProvider credentialsProvider) {
        AmazonSQSClientBuilder builder = (AmazonSQSClientBuilder)AmazonSQSClientBuilder.standard().withCredentials(credentialsProvider);
        if (!this.sqsProperties.getEndpoint().isEmpty()) {
            LOGGER.info("Setting custom SQS endpoint to {}", (Object)this.sqsProperties.getEndpoint());
            builder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.sqsProperties.getEndpoint(), System.getenv("AWS_REGION")));
        }
        return (AmazonSQS)builder.build();
    }

    @Bean
    public EventQueueProvider sqsEventQueueProvider(AmazonSQS sqsClient, SQSEventQueueProperties properties, Scheduler scheduler) {
        return new SQSEventQueueProvider(sqsClient, properties, scheduler);
    }

    @ConditionalOnProperty(name={"conductor.default-event-queue.type"}, havingValue="sqs", matchIfMissing=true)
    @Bean
    public Map<TaskModel.Status, ObservableQueue> getQueues(ConductorProperties conductorProperties, SQSEventQueueProperties properties, AmazonSQS sqsClient) {
        Object stack = "";
        if (conductorProperties.getStack() != null && conductorProperties.getStack().length() > 0) {
            stack = conductorProperties.getStack() + "_";
        }
        TaskModel.Status[] statuses = new TaskModel.Status[]{TaskModel.Status.COMPLETED, TaskModel.Status.FAILED};
        HashMap<TaskModel.Status, ObservableQueue> queues = new HashMap<TaskModel.Status, ObservableQueue>();
        for (TaskModel.Status status : statuses) {
            String[] accounts;
            String queuePrefix = StringUtils.isBlank((CharSequence)properties.getListenerQueuePrefix()) ? conductorProperties.getAppId() + "_sqs_notify_" + (String)stack : properties.getListenerQueuePrefix();
            String queueName = queuePrefix + status.name();
            SQSObservableQueue.Builder builder = new SQSObservableQueue.Builder().withClient(sqsClient).withQueueName(queueName);
            String auth = properties.getAuthorizedAccounts();
            for (String accountToAuthorize : accounts = auth.split(",")) {
                if ((accountToAuthorize = accountToAuthorize.trim()).length() <= 0) continue;
                builder.addAccountToAuthorize(accountToAuthorize.trim());
            }
            SQSObservableQueue queue = builder.build();
            queues.put(status, queue);
        }
        return queues;
    }
}

