/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.rest.controllers;

import com.netflix.conductor.common.metadata.tasks.Task;
import com.netflix.conductor.service.AdminService;
import io.swagger.v3.oas.annotations.Operation;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/admin"})
public class AdminResource {
    private final AdminService adminService;

    public AdminResource(AdminService adminService) {
        this.adminService = adminService;
    }

    @Operation(summary="Get all the configuration parameters")
    @GetMapping(value={"/config"})
    public Map<String, Object> getAllConfig() {
        return this.adminService.getAllConfig();
    }

    @GetMapping(value={"/task/{tasktype}"})
    @Operation(summary="Get the list of pending tasks for a given task type")
    public List<Task> view(@PathVariable(value="tasktype") String taskType, @RequestParam(value="start", defaultValue="0", required=false) int start, @RequestParam(value="count", defaultValue="100", required=false) int count) {
        return this.adminService.getListOfPendingTask(taskType, Integer.valueOf(start), Integer.valueOf(count));
    }

    @PostMapping(value={"/sweep/requeue/{workflowId}"}, produces={"text/plain"})
    @Operation(summary="Queue up all the running workflows for sweep")
    public String requeueSweep(@PathVariable(value="workflowId") String workflowId) {
        return this.adminService.requeueSweep(workflowId);
    }

    @PostMapping(value={"/consistency/verifyAndRepair/{workflowId}"}, produces={"text/plain"})
    @Operation(summary="Verify and repair workflow consistency")
    public String verifyAndRepairWorkflowConsistency(@PathVariable(value="workflowId") String workflowId) {
        return String.valueOf(this.adminService.verifyAndRepairWorkflowConsistency(workflowId));
    }

    @GetMapping(value={"/queues"})
    @Operation(summary="Get registered queues")
    public Map<String, ?> getEventQueues(@RequestParam(value="verbose", defaultValue="false", required=false) boolean verbose) {
        return this.adminService.getEventQueues(verbose);
    }
}

