/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.rest.controllers;

import com.netflix.conductor.common.model.BulkResponse;
import com.netflix.conductor.service.WorkflowBulkService;
import io.swagger.v3.oas.annotations.Operation;
import java.util.List;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/workflow/bulk"})
public class WorkflowBulkResource {
    private final WorkflowBulkService workflowBulkService;

    public WorkflowBulkResource(WorkflowBulkService workflowBulkService) {
        this.workflowBulkService = workflowBulkService;
    }

    @PutMapping(value={"/pause"})
    @Operation(summary="Pause the list of workflows")
    public BulkResponse pauseWorkflow(@RequestBody List<String> workflowIds) {
        return this.workflowBulkService.pauseWorkflow(workflowIds);
    }

    @PutMapping(value={"/resume"})
    @Operation(summary="Resume the list of workflows")
    public BulkResponse resumeWorkflow(@RequestBody List<String> workflowIds) {
        return this.workflowBulkService.resumeWorkflow(workflowIds);
    }

    @PostMapping(value={"/restart"})
    @Operation(summary="Restart the list of completed workflow")
    public BulkResponse restart(@RequestBody List<String> workflowIds, @RequestParam(value="useLatestDefinitions", defaultValue="false", required=false) boolean useLatestDefinitions) {
        return this.workflowBulkService.restart(workflowIds, useLatestDefinitions);
    }

    @PostMapping(value={"/retry"})
    @Operation(summary="Retry the last failed task for each workflow from the list")
    public BulkResponse retry(@RequestBody List<String> workflowIds) {
        return this.workflowBulkService.retry(workflowIds);
    }

    @PostMapping(value={"/terminate"})
    @Operation(summary="Terminate workflows execution")
    public BulkResponse terminate(@RequestBody List<String> workflowIds, @RequestParam(value="reason", required=false) String reason) {
        return this.workflowBulkService.terminate(workflowIds, reason);
    }
}

