/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.rest.startup;

import com.netflix.conductor.common.metadata.tasks.TaskDef;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.event.EventListener;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class KitchenSinkInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(KitchenSinkInitializer.class);
    private final RestTemplate restTemplate;
    @Value(value="${loadSample:false}")
    private boolean loadSamples;
    @Value(value="${server.port:8080}")
    private int port;
    @Value(value="classpath:./kitchensink/kitchensink.json")
    private Resource kitchenSink;
    @Value(value="classpath:./kitchensink/sub_flow_1.json")
    private Resource subFlow;
    @Value(value="classpath:./kitchensink/kitchenSink-ephemeralWorkflowWithStoredTasks.json")
    private Resource ephemeralWorkflowWithStoredTasks;
    @Value(value="classpath:./kitchensink/kitchenSink-ephemeralWorkflowWithEphemeralTasks.json")
    private Resource ephemeralWorkflowWithEphemeralTasks;

    public KitchenSinkInitializer(RestTemplateBuilder restTemplateBuilder) {
        this.restTemplate = restTemplateBuilder.build();
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void setupKitchenSink() {
        try {
            if (this.loadSamples) {
                LOGGER.info("Loading Kitchen Sink examples");
                this.createKitchenSink();
            }
        }
        catch (Exception e) {
            LOGGER.error("Error initializing kitchen sink", (Throwable)e);
        }
    }

    private void createKitchenSink() throws Exception {
        TaskDef taskDef;
        LinkedList<TaskDef> taskDefs = new LinkedList<TaskDef>();
        for (int i = 0; i < 40; ++i) {
            taskDef = new TaskDef("task_" + i, "task_" + i, 1, 0L);
            taskDef.setOwnerEmail("example@email.com");
            taskDefs.add(taskDef);
        }
        taskDef = new TaskDef("search_elasticsearch", "search_elasticsearch", 1, 0L);
        taskDef.setOwnerEmail("example@email.com");
        taskDefs.add(taskDef);
        this.restTemplate.postForEntity(this.url("/api/metadata/taskdefs"), taskDefs, Object.class, new Object[0]);
        LinkedMultiValueMap headers = new LinkedMultiValueMap();
        headers.add((Object)"Content-Type", (Object)"application/json");
        HttpEntity request = new HttpEntity((Object)this.readToString(this.kitchenSink), (MultiValueMap)headers);
        this.restTemplate.postForEntity(this.url("/api/metadata/workflow/"), (Object)request, Map.class, new Object[0]);
        request = new HttpEntity((Object)this.readToString(this.subFlow), (MultiValueMap)headers);
        this.restTemplate.postForEntity(this.url("/api/metadata/workflow/"), (Object)request, Map.class, new Object[0]);
        this.restTemplate.postForEntity(this.url("/api/workflow/kitchensink"), Collections.singletonMap("task2Name", "task_5"), String.class, new Object[0]);
        LOGGER.info("Kitchen sink workflow is created!");
        request = new HttpEntity((Object)this.readToString(this.ephemeralWorkflowWithStoredTasks), (MultiValueMap)headers);
        this.restTemplate.postForEntity(this.url("/api/workflow/"), (Object)request, String.class, new Object[0]);
        LOGGER.info("Ephemeral Kitchen sink workflow with stored tasks is created!");
        request = new HttpEntity((Object)this.readToString(this.ephemeralWorkflowWithEphemeralTasks), (MultiValueMap)headers);
        this.restTemplate.postForEntity(this.url("/api/workflow/"), (Object)request, String.class, new Object[0]);
        LOGGER.info("Ephemeral Kitchen sink workflow with ephemeral tasks is created!");
    }

    private String readToString(Resource resource) throws IOException {
        return FileCopyUtils.copyToString((Reader)new InputStreamReader(resource.getInputStream()));
    }

    private String url(String path) {
        return "http://localhost:" + this.port + path;
    }
}

