/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import java.util.ArrayList;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;

final class CryptoUpcalls {
    private CryptoUpcalls() {
    }

    private static boolean isOurProvider(Provider p) {
        return p.getClass().getPackage().equals(CryptoUpcalls.class.getPackage());
    }

    private static ArrayList<Provider> getExternalProviders(String algorithm) {
        ArrayList<Provider> providers = new ArrayList<Provider>(1);
        for (Provider p : Security.getProviders(algorithm)) {
            if (CryptoUpcalls.isOurProvider(p)) continue;
            providers.add(p);
        }
        if (providers.isEmpty()) {
            System.err.println("Could not find external provider for algorithm: " + algorithm);
        }
        return providers;
    }

    static byte[] rawSignDigestWithPrivateKey(PrivateKey javaKey, byte[] message) {
        Signature signature;
        String algorithm;
        String keyAlgorithm = javaKey.getAlgorithm();
        if ("RSA".equals(keyAlgorithm)) {
            algorithm = "NONEwithRSA";
        } else if ("EC".equals(keyAlgorithm)) {
            algorithm = "NONEwithECDSA";
        } else {
            throw new RuntimeException("Unexpected key type: " + javaKey.toString());
        }
        try {
            signature = Signature.getInstance(algorithm);
            signature.initSign(javaKey);
            if (CryptoUpcalls.isOurProvider(signature.getProvider())) {
                signature = null;
            }
        }
        catch (NoSuchAlgorithmException e) {
            System.err.println("Unsupported signature algorithm: " + algorithm);
            return null;
        }
        catch (InvalidKeyException e) {
            System.err.println("Preferred provider doesn't support key:");
            e.printStackTrace();
            signature = null;
        }
        if (signature == null) {
            ArrayList<Provider> providers = CryptoUpcalls.getExternalProviders("Signature." + algorithm);
            for (Provider p : providers) {
                try {
                    signature = Signature.getInstance(algorithm, p);
                    signature.initSign(javaKey);
                    break;
                }
                catch (InvalidKeyException | NoSuchAlgorithmException e) {
                    signature = null;
                }
            }
            if (signature == null) {
                System.err.println("Could not find provider for algorithm: " + algorithm);
                return null;
            }
        }
        try {
            signature.update(message);
            return signature.sign();
        }
        catch (Exception e) {
            System.err.println("Exception while signing message with " + javaKey.getAlgorithm() + " private key:");
            e.printStackTrace();
            return null;
        }
    }

    static byte[] rsaDecryptWithPrivateKey(PrivateKey javaKey, int openSSLPadding, byte[] input) {
        String jcaPadding;
        String keyAlgorithm = javaKey.getAlgorithm();
        if (!"RSA".equals(keyAlgorithm)) {
            System.err.println("Unexpected key type: " + keyAlgorithm);
            return null;
        }
        switch (openSSLPadding) {
            case 1: {
                jcaPadding = "PKCS1Padding";
                break;
            }
            case 3: {
                jcaPadding = "NoPadding";
                break;
            }
            case 4: {
                jcaPadding = "OAEPPadding";
                break;
            }
            default: {
                System.err.println("Unsupported OpenSSL/BoringSSL padding: " + openSSLPadding);
                return null;
            }
        }
        String transformation = "RSA/ECB/" + jcaPadding;
        Cipher c = null;
        try {
            c = Cipher.getInstance(transformation);
            c.init(2, javaKey);
            if (CryptoUpcalls.isOurProvider(c.getProvider())) {
                c = null;
            }
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            System.err.println("Unsupported cipher algorithm: " + transformation);
            return null;
        }
        catch (InvalidKeyException e) {
            System.err.println("Preferred provider doesn't support key:");
            e.printStackTrace();
            c = null;
        }
        if (c == null) {
            ArrayList<Provider> providers = CryptoUpcalls.getExternalProviders("Cipher." + transformation);
            for (Provider p : providers) {
                try {
                    c = Cipher.getInstance(transformation, p);
                    c.init(2, javaKey);
                    break;
                }
                catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
                    c = null;
                }
            }
            if (c == null) {
                System.err.println("Could not find provider for algorithm: " + transformation);
                return null;
            }
        }
        try {
            return c.doFinal(input);
        }
        catch (Exception e) {
            System.err.println("Exception while decrypting message with " + javaKey.getAlgorithm() + " private key using " + transformation + ":");
            e.printStackTrace();
            return null;
        }
    }
}

