/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.scoping;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.function.Predicate;
import org.contextmapper.dsl.contextMappingDSL.impl.BoundedContextImpl;
import org.contextmapper.dsl.contextMappingDSL.impl.DomainImpl;
import org.contextmapper.tactic.dsl.tacticdsl.Association;
import org.contextmapper.tactic.dsl.tacticdsl.DomainObject;
import org.contextmapper.tactic.dsl.tacticdsl.Reference;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.SimpleScope;

public class CMLScopingHelper {
    public IScope reduceReferenceScope(IScope existingScope, Reference reference, EReference eReference) {
        if (this.isPartOfBoundedContext(reference)) {
            return this.filterScope(existingScope, ieoDesc -> ieoDesc.getEObjectOrProxy() instanceof DomainObject && this.isPartOfDomain(ieoDesc.getEObjectOrProxy()));
        }
        if (this.isPartOfDomain(reference)) {
            return this.filterScope(existingScope, ieoDesc -> ieoDesc.getEObjectOrProxy() instanceof DomainObject && this.isPartOfBoundedContext(ieoDesc.getEObjectOrProxy()));
        }
        return existingScope;
    }

    public IScope reduceReferenceScope(IScope existingScope, Association association, EReference eReference) {
        if (this.isPartOfBoundedContext(association)) {
            return this.filterScope(existingScope, ieoDesc -> ieoDesc.getEObjectOrProxy() instanceof DomainObject && this.isPartOfDomain(ieoDesc.getEObjectOrProxy()));
        }
        if (this.isPartOfDomain(association)) {
            return this.filterScope(existingScope, ieoDesc -> ieoDesc.getEObjectOrProxy() instanceof DomainObject && this.isPartOfBoundedContext(ieoDesc.getEObjectOrProxy()));
        }
        return existingScope;
    }

    private IScope filterScope(IScope scope, Predicate<IEObjectDescription> descriptionsToRemovePredicate) {
        LinkedList descriptions = Lists.newLinkedList();
        for (IEObjectDescription ieoDesc : scope.getAllElements()) {
            if (descriptionsToRemovePredicate.test(ieoDesc)) continue;
            descriptions.add(ieoDesc);
        }
        return new SimpleScope((Iterable)descriptions);
    }

    private boolean isPartOfBoundedContext(EObject object) {
        return this.getParentTypes(object).contains(BoundedContextImpl.class);
    }

    private boolean isPartOfDomain(EObject object) {
        return this.getParentTypes(object).contains(DomainImpl.class);
    }

    private Set<Class<? extends EObject>> getParentTypes(EObject object) {
        HashSet parentTypes = Sets.newHashSet();
        for (EObject parent = object.eContainer(); parent != null; parent = parent.eContainer()) {
            parentTypes.add(parent.getClass());
        }
        return parentTypes;
    }
}

