/**
 * Copyright 2018 The Context Mapper Project Team
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *    http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.contextmapper.dsl.ide;

import com.google.inject.Guice;
import com.google.inject.Injector;
import org.contextmapper.dsl.ContextMappingDSLRuntimeModule;
import org.contextmapper.dsl.ContextMappingDSLStandaloneSetup;
import org.contextmapper.dsl.ide.ContextMappingDSLIdeModule;
import org.eclipse.xtext.util.Modules2;

/**
 * Initialization support for running Xtext languages as language servers.
 */
@SuppressWarnings("all")
public class ContextMappingDSLIdeSetup extends ContextMappingDSLStandaloneSetup {
  @Override
  public Injector createInjector() {
    ContextMappingDSLRuntimeModule _contextMappingDSLRuntimeModule = new ContextMappingDSLRuntimeModule();
    ContextMappingDSLIdeModule _contextMappingDSLIdeModule = new ContextMappingDSLIdeModule();
    return Guice.createInjector(Modules2.mixin(_contextMappingDSLRuntimeModule, _contextMappingDSLIdeModule));
  }
}
