/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.ide.actions;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.contextmapper.dsl.cml.CMLResourceContainer;
import org.contextmapper.dsl.exception.ContextMapperApplicationException;
import org.contextmapper.dsl.ide.actions.CMLCodeAction;
import org.contextmapper.dsl.ide.actions.SelectionContextResolver;
import org.contextmapper.dsl.ide.actions.impl.DeriveBoundedContextFromSubdomainsAction;
import org.contextmapper.dsl.ide.actions.impl.DeriveSubdomainFromUserRequirementsAction;
import org.contextmapper.dsl.ide.actions.impl.SplitAggregateByEntitiesAction;
import org.contextmapper.dsl.ide.actions.impl.SplitBoundedContextByFeaturesAction;
import org.contextmapper.dsl.ide.actions.impl.SplitBoundedContextByOwnerAction;
import org.contextmapper.dsl.ide.edit.WorkspaceEditRecorder;
import org.contextmapper.dsl.quickfixes.CMLQuickFix;
import org.contextmapper.dsl.quickfixes.tactic.ExtractIDValueObjectQuickFix;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.xtext.ide.serializer.IChangeSerializer;
import org.eclipse.xtext.ide.server.codeActions.ICodeActionService2;

public class CMLActionRegistry {
    @Inject
    private WorkspaceEditRecorder editRecorder;
    @Inject
    private SelectionContextResolver selectionResolver;
    private Map<String, List<CMLQuickFix<? extends EObject>>> quickFixRegistry = Maps.newHashMap();

    public CMLActionRegistry() {
        this.registerAllQuickFixes();
    }

    private Set<CMLCodeAction> getAllActions(CMLResourceContainer resource, List<EObject> selectedObjects) {
        HashSet codeActions = Sets.newHashSet();
        codeActions.add(new SplitBoundedContextByOwnerAction(resource, selectedObjects));
        codeActions.add(new SplitBoundedContextByFeaturesAction(resource, selectedObjects));
        codeActions.add(new SplitAggregateByEntitiesAction(resource, selectedObjects));
        codeActions.add(new DeriveSubdomainFromUserRequirementsAction(resource, selectedObjects));
        codeActions.add(new DeriveBoundedContextFromSubdomainsAction(resource, selectedObjects));
        return Sets.newHashSet((Iterable)codeActions);
    }

    private void registerAllQuickFixes() {
        this.registerQuickFix("primitive-id-detected", (CMLQuickFix<? extends EObject>)new ExtractIDValueObjectQuickFix());
    }

    public List<? extends Command> getApplicableActionCommands(CMLResourceContainer resource, List<EObject> selectedObjects) {
        List result = this.getAllActions(resource, selectedObjects).stream().filter(a -> a.isApplicable()).map(a -> a.getCommand()).collect(Collectors.toList());
        return result;
    }

    public List<? extends CodeAction> getApplicableQuickfixes(Diagnostic diagnostic, ICodeActionService2.Options options) {
        LinkedList quickFixCodeActions = Lists.newLinkedList();
        if (diagnostic.getCode() == null || diagnostic.getCode().get() == null || !(diagnostic.getCode().get() instanceof String)) {
            return quickFixCodeActions;
        }
        String key = (String)diagnostic.getCode().get();
        if (!this.quickFixRegistry.containsKey(key) || this.quickFixRegistry.get(key).isEmpty()) {
            return quickFixCodeActions;
        }
        quickFixCodeActions.addAll(this.createQuickFixCodeActions4ValidationMessage(key, diagnostic, options));
        return quickFixCodeActions;
    }

    private List<CodeAction> createQuickFixCodeActions4ValidationMessage(String validationId, Diagnostic diagnostic, ICodeActionService2.Options options) {
        LinkedList codeActions = Lists.newLinkedList();
        for (CMLQuickFix<? extends EObject> quickFix : this.quickFixRegistry.get(validationId)) {
            codeActions.add(this.createQuickFixCodeAction(quickFix, diagnostic, options));
        }
        return codeActions;
    }

    private CodeAction createQuickFixCodeAction(CMLQuickFix<? extends EObject> quickFix, Diagnostic diagnostic, ICodeActionService2.Options options) {
        CodeAction action = new CodeAction(quickFix.getName());
        action.setDiagnostics(Arrays.asList(diagnostic));
        action.setKind("quickfix");
        action.setEdit(this.editRecorder.recordWorkspaceEdit(options.getLanguageServerAccess(), options.getResource().getURI(), options.getDocument(), (IChangeSerializer.IModification<Resource>)((IChangeSerializer.IModification)resource -> {
            CMLResourceContainer cmlResource = new CMLResourceContainer(resource);
            List<EObject> objects = this.selectionResolver.resolveAllSelectedEObjects(cmlResource, options.getDocument().getOffSet(diagnostic.getRange().getStart()), options.getDocument().getOffSet(diagnostic.getRange().getEnd()));
            if (objects.isEmpty()) {
                throw new ContextMapperApplicationException("Selected object for quick fix could not be found.");
            }
            quickFix.applyQuickfix2EObject(EcoreUtil.resolve((EObject)objects.get(0), (Resource)resource));
        })));
        return action;
    }

    private void registerQuickFix(String validationId, CMLQuickFix<? extends EObject> quickFix) {
        if (!this.quickFixRegistry.containsKey(validationId)) {
            this.quickFixRegistry.put(validationId, Lists.newLinkedList());
        }
        this.quickFixRegistry.get(validationId).add(quickFix);
    }
}

