/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.ide.actions.impl;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.contextmapper.dsl.cml.CMLResourceContainer;
import org.contextmapper.dsl.contextMappingDSL.Subdomain;
import org.contextmapper.dsl.ide.actions.CMLCodeAction;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.lsp4j.Command;

public class DeriveBoundedContextFromSubdomainsAction
implements CMLCodeAction {
    private CMLResourceContainer cmlResource;
    private List<EObject> editorSelection;

    public DeriveBoundedContextFromSubdomainsAction(CMLResourceContainer cmlResource, List<EObject> editorSelection) {
        this.cmlResource = cmlResource;
        this.editorSelection = editorSelection;
    }

    @Override
    public boolean isApplicable() {
        return !this.getSelectedSubdomains().isEmpty();
    }

    @Override
    public Command getCommand() {
        LinkedList commandArguments = Lists.newLinkedList();
        commandArguments.add(this.cmlResource.getResource().getURI().toString());
        commandArguments.addAll(this.getSelectedSubdomains().stream().map(ur -> ur.getName()).collect(Collectors.toSet()));
        return new Command("Derive Bounded Context From Subdomains", "cml.ar.deriveBoundedContextFromSDs.proxy", (List)commandArguments);
    }

    private Set<Subdomain> getSelectedSubdomains() {
        return this.editorSelection.stream().filter(o -> o instanceof Subdomain).map(o -> (Subdomain)o).collect(Collectors.toSet());
    }
}

