/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.ide.actions.impl;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.contextmapper.dsl.cml.CMLResourceContainer;
import org.contextmapper.dsl.contextMappingDSL.BoundedContext;
import org.contextmapper.dsl.ide.actions.CMLCodeAction;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.lsp4j.Command;

public class SplitBoundedContextByFeaturesAction
implements CMLCodeAction {
    private CMLResourceContainer cmlResource;
    private List<EObject> editorSelection;

    public SplitBoundedContextByFeaturesAction(CMLResourceContainer cmlResource, List<EObject> editorSelection) {
        this.cmlResource = cmlResource;
        this.editorSelection = editorSelection;
    }

    @Override
    public boolean isApplicable() {
        Set<BoundedContext> boundedContexts = this.getSelectedBoundedContexts();
        if (boundedContexts.isEmpty() || boundedContexts.size() > 1) {
            return false;
        }
        BoundedContext selectedContext = boundedContexts.iterator().next();
        Set useCaseSets = selectedContext.getAggregates().stream().map(agg -> agg.getUserRequirements().stream().map(uc -> uc.getName()).collect(Collectors.joining(", "))).collect(Collectors.toSet());
        return useCaseSets.size() > 1;
    }

    @Override
    public Command getCommand() {
        LinkedList commandArguments = Lists.newLinkedList();
        commandArguments.add(this.cmlResource.getResource().getURI().toString());
        commandArguments.add(this.getSelectedBoundedContext().getName());
        return new Command("Split Bounded Context by Features", "cml.ar.splitBCByFeature", (List)commandArguments);
    }

    private BoundedContext getSelectedBoundedContext() {
        Set<BoundedContext> boundedContexts = this.getSelectedBoundedContexts();
        return boundedContexts.iterator().next();
    }

    private Set<BoundedContext> getSelectedBoundedContexts() {
        return this.editorSelection.stream().filter(o -> o instanceof BoundedContext).map(o -> (BoundedContext)o).collect(Collectors.toSet());
    }
}

