/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.ide.commands;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Map;
import java.util.Set;
import org.contextmapper.dsl.ide.commands.CMLResourceCommand;
import org.contextmapper.dsl.ide.commands.impl.generation.ContextMapGenerationCommand;
import org.contextmapper.dsl.ide.commands.impl.generation.GenericTextFileGenerationCommand;
import org.contextmapper.dsl.ide.commands.impl.generation.MDSLGenerationCommand;
import org.contextmapper.dsl.ide.commands.impl.generation.PlantUMLGenerationCommand;
import org.contextmapper.dsl.ide.commands.impl.refactoring.DeriveBoundedContextFromSubdomainsCommand;
import org.contextmapper.dsl.ide.commands.impl.refactoring.DeriveSubdomainFromUserRequirementsCommand;
import org.contextmapper.dsl.ide.commands.impl.refactoring.SplitAggregateByEntitiesRefactoringCommand;
import org.contextmapper.dsl.ide.commands.impl.refactoring.SplitBoundedContextByFeaturesRefactoringCommand;
import org.contextmapper.dsl.ide.commands.impl.refactoring.SplitBoundedContextByOwnerRefactoringCommand;
import org.contextmapper.dsl.ide.edit.WorkspaceEditRecorder;

public class CMLCommandRegistry {
    private Map<String, CMLResourceCommand> commandMap = Maps.newHashMap();
    private WorkspaceEditRecorder editRecorder;

    @Inject
    public CMLCommandRegistry(WorkspaceEditRecorder editRecorder) {
        this.editRecorder = editRecorder;
        this.registerCommands();
    }

    private void registerCommands() {
        this.commandMap.put("cml.generate.contextmap", new ContextMapGenerationCommand());
        this.commandMap.put("cml.generate.puml", new PlantUMLGenerationCommand());
        this.commandMap.put("cml.generate.mdsl", new MDSLGenerationCommand());
        this.commandMap.put("cml.generate.generic.text.file", new GenericTextFileGenerationCommand());
        this.commandMap.put("cml.ar.splitBCByOwner", new SplitBoundedContextByOwnerRefactoringCommand(this.editRecorder));
        this.commandMap.put("cml.ar.splitBCByFeature", new SplitBoundedContextByFeaturesRefactoringCommand(this.editRecorder));
        this.commandMap.put("cml.ar.splitAggregateByEntities", new SplitAggregateByEntitiesRefactoringCommand(this.editRecorder));
        this.commandMap.put("cml.ar.deriveSubdomainFromURs", new DeriveSubdomainFromUserRequirementsCommand(this.editRecorder));
        this.commandMap.put("cml.ar.deriveBoundedContextFromSDs", new DeriveBoundedContextFromSubdomainsCommand(this.editRecorder));
    }

    public CMLResourceCommand getCommand(String commandId) {
        return this.commandMap.get(commandId);
    }

    public Set<String> getCommandIds() {
        return Sets.newHashSet(this.commandMap.keySet());
    }
}

