/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.ide.commands.impl.generation;

import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import org.contextmapper.dsl.cml.CMLResourceContainer;
import org.contextmapper.dsl.exception.ContextMapperApplicationException;
import org.contextmapper.dsl.generator.ContextMapGenerator;
import org.contextmapper.dsl.generator.contextmap.ContextMapFormat;
import org.contextmapper.dsl.ide.commands.impl.generation.AbstractGenerationCommand;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.xtext.generator.IGenerator2;
import org.eclipse.xtext.ide.server.Document;
import org.eclipse.xtext.ide.server.ILanguageServerAccess;

public class ContextMapGenerationCommand
extends AbstractGenerationCommand {
    private ContextMapGenerator generator = new ContextMapGenerator();

    @Override
    IGenerator2 getGenerator() {
        return this.generator;
    }

    @Override
    public void executeCommand(CMLResourceContainer cmlResource, Document document, ILanguageServerAccess access, ExecuteCommandParams params) {
        if (params.getArguments().size() != 2 || params.getArguments().get(1).getClass() != JsonArray.class) {
            throw new ContextMapperApplicationException("This command expects a JSON array with the generator parameters as a second parameter.");
        }
        JsonArray paramArray = (JsonArray)params.getArguments().get(1);
        JsonObject paramObject = paramArray.get(0).getAsJsonObject();
        ContextMapFormat[] formats = this.getFormatsFromInputArray(paramObject.get("formats").getAsJsonArray());
        boolean fixWidth = paramObject.get("fixWidth").getAsBoolean();
        boolean fixHeight = paramObject.get("fixHeight").getAsBoolean();
        boolean generateLabels = paramObject.get("generateLabels").getAsBoolean();
        int labelSpacingFactor = paramObject.get("labelSpacingFactor").getAsInt();
        this.generator.setContextMapFormats(formats);
        this.generator.setLabelSpacingFactor(labelSpacingFactor);
        this.generator.printAdditionalLabels(generateLabels);
        if (fixWidth) {
            this.generator.setWidth(paramObject.get("width").getAsInt());
        } else if (fixHeight) {
            this.generator.setHeight(paramObject.get("height").getAsInt());
        }
        super.executeCommand(cmlResource, document, access, params);
    }

    private ContextMapFormat[] getFormatsFromInputArray(JsonArray formatsArray) {
        HashSet formats = Sets.newHashSet();
        for (JsonElement element : formatsArray) {
            formats.add(ContextMapFormat.valueOf((String)element.getAsString().toUpperCase()));
        }
        return formats.toArray(new ContextMapFormat[formats.size()]);
    }
}

