/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.ide.commands.impl.generation;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import org.contextmapper.dsl.cml.CMLResourceContainer;
import org.contextmapper.dsl.exception.ContextMapperApplicationException;
import org.contextmapper.dsl.generator.GenericContentGenerator;
import org.contextmapper.dsl.generator.exception.GeneratorInputException;
import org.contextmapper.dsl.ide.commands.impl.generation.AbstractGenerationCommand;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.xtext.generator.IGenerator2;
import org.eclipse.xtext.ide.server.Document;
import org.eclipse.xtext.ide.server.ILanguageServerAccess;

public class GenericTextFileGenerationCommand
extends AbstractGenerationCommand {
    private GenericContentGenerator generator = new GenericContentGenerator();

    @Override
    IGenerator2 getGenerator() {
        return this.generator;
    }

    @Override
    public void executeCommand(CMLResourceContainer cmlResource, Document document, ILanguageServerAccess access, ExecuteCommandParams params) {
        if (params.getArguments().size() != 2 || params.getArguments().get(1).getClass() != JsonArray.class) {
            throw new ContextMapperApplicationException("This command expects a JSON array with the following values as second parameter: URI to Freemarker template, filename string for output file");
        }
        JsonArray paramArray = (JsonArray)params.getArguments().get(1);
        JsonObject paramObject = paramArray.get(0).getAsJsonObject();
        try {
            URI templateURI = new URI(paramObject.get("templateUri").getAsString());
            if (!templateURI.toString().startsWith("file:")) {
                throw new GeneratorInputException("Please provide a URI to a local file (Freemarker template)!");
            }
            this.generator.setFreemarkerTemplateFile(Paths.get(templateURI).toFile());
            this.generator.setTargetFileName(paramObject.get("outputFileName").getAsString());
        }
        catch (URISyntaxException e) {
            throw new ContextMapperApplicationException("The passed template URI is not a valid URI.", (Throwable)e);
        }
        super.executeCommand(cmlResource, document, access, params);
    }
}

