/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.ide.edit;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.xtext.ide.serializer.IChangeSerializer;
import org.eclipse.xtext.ide.serializer.ITextDocumentChange;
import org.eclipse.xtext.ide.server.Document;
import org.eclipse.xtext.ide.server.ILanguageServerAccess;
import org.eclipse.xtext.util.CollectionBasedAcceptor;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class WorkspaceEditRecorder {
    @Inject
    private Provider<IChangeSerializer> serializerProvider;

    public WorkspaceEdit recordWorkspaceEdit(ILanguageServerAccess access, URI resourceURI, Document document, IChangeSerializer.IModification<Resource> mod) {
        ResourceSet rs = access.newLiveScopeResourceSet(resourceURI);
        Resource copy = rs.getResource(resourceURI, true);
        IChangeSerializer serializer = (IChangeSerializer)this.serializerProvider.get();
        EcoreUtil.resolveAll((Resource)copy);
        serializer.addModification((Notifier)copy, mod);
        ArrayList documentchanges = new ArrayList();
        serializer.applyModifications((IAcceptor)CollectionBasedAcceptor.of(documentchanges));
        WorkspaceEdit workspaceEdit = new WorkspaceEdit();
        for (ITextDocumentChange documentchange : Iterables.filter(documentchanges, ITextDocumentChange.class)) {
            List edits = ListExtensions.map((List)documentchange.getReplacements(), replacement -> {
                TextEdit textEdit = new TextEdit();
                textEdit.setNewText(replacement.getReplacementText());
                textEdit.setRange(new Range(document.getPosition(replacement.getOffset()), document.getPosition(replacement.getEndOffset())));
                return textEdit;
            });
            workspaceEdit.getChanges().put(documentchange.getNewURI().toString(), edits);
        }
        return workspaceEdit;
    }
}

