/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.model.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.henshin.HenshinModelPlugin;
import org.eclipse.emf.henshin.model.Action;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.GraphElement;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.MappingList;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.actions.ActionHelper;
import org.eclipse.emf.henshin.model.actions.ConditionElemMapEditor;
import org.eclipse.emf.henshin.model.actions.MapEditor;
import org.eclipse.emf.henshin.model.actions.MultiRuleMapEditor;
import org.eclipse.emf.henshin.model.util.HenshinModelCleaner;

public abstract class GenericActionHelper<E extends GraphElement, C extends EObject>
implements ActionHelper<E, C> {
    @Override
    public Action getAction(E element) {
        String[] multiPath;
        Graph graph = element.getGraph();
        if (graph == null) {
            return null;
        }
        Rule rule = graph.getRule();
        if (rule == null) {
            return null;
        }
        Rule kernel = rule.getKernelRule();
        boolean isMulti = this.isMulti(element);
        String[] stringArray = multiPath = isMulti ? this.getMultiPath(element, rule) : null;
        if (kernel != null && !isMulti) {
            return null;
        }
        if (graph == rule.getLhs()) {
            MapEditor<E> editor = this.getMapEditor(rule.getRhs());
            E image = editor.getOpposite(element);
            if (image != null) {
                return new Action(Action.Type.PRESERVE, isMulti, multiPath);
            }
            return new Action(Action.Type.DELETE, isMulti, multiPath);
        }
        if (graph == rule.getRhs()) {
            MapEditor<E> editor = this.getMapEditor(rule.getRhs());
            E origin = editor.getOpposite(element);
            if (origin == null) {
                return new Action(Action.Type.CREATE, isMulti, multiPath);
            }
        } else if (graph.eContainer() instanceof NestedCondition) {
            MapEditor<E> editor;
            E origin;
            NestedCondition nc = (NestedCondition)graph.eContainer();
            Action.Type type = null;
            if (nc.isPAC()) {
                type = Action.Type.REQUIRE;
            } else if (nc.isNAC()) {
                type = Action.Type.FORBID;
            }
            if (type != null && (origin = (editor = this.getMapEditor(graph)).getOpposite(element)) == null) {
                return new Action(type, isMulti, multiPath, graph.getName());
            }
        }
        return null;
    }

    @Override
    public void setAction(E element, Action newAction) {
        NestedCondition ac;
        Action oldAction = this.getAction(element);
        if (oldAction == null) {
            return;
        }
        if (newAction.equals(oldAction)) {
            return;
        }
        Action.Type oldType = oldAction.getType();
        Action.Type newType = newAction.getType();
        Graph graph = element.getGraph();
        Rule rule = graph.getRule();
        if (oldType == Action.Type.PRESERVE) {
            MapEditor<E> editor = this.getMapEditor(rule.getRhs());
            E image = editor.getOpposite(element);
            if (newType == Action.Type.DELETE) {
                editor.remove(image);
            } else if (newType == Action.Type.CREATE) {
                editor.replace(image);
            } else if (newType == Action.Type.REQUIRE || newType == Action.Type.FORBID) {
                editor.remove(image);
                NestedCondition ac2 = this.getOrCreateAC(newAction, rule);
                editor = this.getMapEditor(ac2.getConclusion());
                editor.move(element);
            }
        } else if (oldType == Action.Type.CREATE) {
            MapEditor<E> editor = this.getMapEditor(rule.getRhs());
            if (newType != Action.Type.CREATE) {
                editor.move(element);
            }
            if (newType == Action.Type.PRESERVE) {
                editor.copy(element);
            } else if (newType == Action.Type.REQUIRE || newType == Action.Type.FORBID) {
                ac = this.getOrCreateAC(newAction, rule);
                editor = this.getMapEditor(ac.getConclusion());
                editor.move(element);
            }
        } else if (oldType == Action.Type.DELETE) {
            MapEditor<E> editor = this.getMapEditor(rule.getRhs());
            if (newType == Action.Type.PRESERVE) {
                editor.copy(element);
            } else if (newType == Action.Type.CREATE) {
                editor.move(element);
            } else if (newType == Action.Type.REQUIRE || newType == Action.Type.FORBID) {
                ac = this.getOrCreateAC(newAction, rule);
                editor = this.getMapEditor(ac.getConclusion());
                editor.move(element);
            }
        } else if (!(oldType != Action.Type.REQUIRE && oldType != Action.Type.FORBID || oldType == newType && oldAction.hasSameFragment(newAction))) {
            ac = (NestedCondition)graph.eContainer();
            MapEditor<E> editor = this.getMapEditor(ac.getConclusion());
            editor.move(element);
            if (newType == Action.Type.PRESERVE) {
                editor = this.getMapEditor(rule.getRhs());
                editor.copy(element);
            } else if (newType == Action.Type.CREATE) {
                editor = this.getMapEditor(rule.getRhs());
                editor.move(element);
            } else if (newType == Action.Type.REQUIRE || newType == Action.Type.FORBID) {
                NestedCondition newAc = this.getOrCreateAC(newAction, rule);
                editor = this.getMapEditor(newAc.getConclusion());
                editor.move(element);
            }
        }
        oldAction = this.getAction(element);
        if (oldAction.isMulti()) {
            if (!newAction.isMulti()) {
                this.moveMultiElement(rule, rule.getRootRule(), newAction, element);
            } else if (!oldAction.hasSamePath(newAction)) {
                String[] common = GenericActionHelper.getCommonPath(oldAction, newAction);
                if (common.length == 0) {
                    this.moveMultiElement(rule, rule.getRootRule(), newAction, element);
                } else {
                    Action action = new Action(oldAction.getType(), true, common);
                    Rule multi = this.getOrCreateMultiRule(rule.getRootRule(), action);
                    this.moveMultiElement(rule, multi, newAction, element);
                }
            }
        }
        if ((oldAction = this.getAction(element)) != null && !oldAction.equals(newAction)) {
            Rule multi = this.getOrCreateMultiRule(rule.getRootRule(), newAction);
            this.moveMultiElement(element.getGraph().getRule(), multi, newAction, element);
        }
        if (!newAction.equals(this.getAction(element))) {
            HenshinModelPlugin.INSTANCE.logWarning("Failed to set action for " + element + " (got " + this.getAction(element) + " instead of " + newAction, null);
        }
        HenshinModelCleaner.cleanRule(rule.getRootRule());
    }

    private static String[] getCommonPath(Action a1, Action a2) {
        ArrayList<String> path = new ArrayList<String>();
        String[] p1 = a1.getPath();
        String[] p2 = a2.getPath();
        int max = Math.min(p1.length, p2.length);
        for (int i = 0; i < max && p1[i].equals(p2[i]); ++i) {
            path.add(p1[i]);
        }
        return path.toArray(new String[0]);
    }

    private void moveMultiElement(Rule rule1, Rule rule2, Action action, E element) {
        if (rule1 == rule2) {
            return;
        }
        if (EcoreUtil.isAncestor((EObject)rule2, (EObject)rule1)) {
            this.moveMultiElement(rule2, rule1, action, element);
            return;
        }
        ArrayList<Rule> ruleChain = new ArrayList<Rule>();
        Rule rule = rule2;
        ruleChain.add(rule);
        while (rule != rule1 && rule != null) {
            if ((rule = rule.getKernelRule()) == null) continue;
            ruleChain.add(0, rule);
        }
        if (element.getGraph().getRule() != rule1) {
            if (element.getGraph().getRule() == rule2) {
                Collections.reverse(ruleChain);
            } else {
                return;
            }
        }
        Action.Type actionType = action.getType();
        for (int i = 1; i < ruleChain.size(); ++i) {
            Rule multi;
            Rule kernel;
            Rule r1 = (Rule)ruleChain.get(i - 1);
            Rule r2 = (Rule)ruleChain.get(i);
            if (r2.getKernelRule() == r1) {
                kernel = r1;
                multi = r2;
            } else {
                kernel = r2;
                multi = r1;
            }
            if (actionType == Action.Type.CREATE) {
                this.getMapEditor(kernel.getRhs(), multi.getRhs(), multi.getMultiMappings()).move(element);
                continue;
            }
            if (actionType == Action.Type.DELETE) {
                this.getMapEditor(kernel.getLhs(), multi.getLhs(), multi.getMultiMappings()).move(element);
                continue;
            }
            if (actionType == Action.Type.PRESERVE) {
                new MultiRuleMapEditor(kernel, multi).moveMappedElement(element);
                continue;
            }
            if (actionType != Action.Type.FORBID && actionType != Action.Type.REQUIRE) continue;
            NestedCondition kernelAC = this.getOrCreateAC(kernel, action.getFragment(), actionType == Action.Type.REQUIRE);
            NestedCondition currentAC = this.getOrCreateAC(multi, action.getFragment(), actionType == Action.Type.REQUIRE);
            new ConditionElemMapEditor(kernelAC, currentAC).moveConditionElement(element);
        }
    }

    protected abstract MapEditor<E> getMapEditor(Graph var1);

    protected abstract MapEditor<E> getMapEditor(Graph var1, Graph var2, MappingList var3);

    protected List<E> filterElementsByAction(List<E> elements, Action action) {
        ArrayList<GraphElement> result = new ArrayList<GraphElement>();
        for (GraphElement element : elements) {
            Action current = this.getAction(element);
            if (current == null || action != null && !action.equals(current)) continue;
            result.add(element);
        }
        return result;
    }

    private boolean isMulti(E element) {
        Node elem;
        if (element instanceof Attribute) {
            elem = ((Attribute)element).getNode();
        } else if (element instanceof GraphElement) {
            elem = element;
        } else {
            return false;
        }
        Graph graph = elem.getGraph();
        if (graph == null) {
            return false;
        }
        Rule rule = graph.getRule();
        if (rule == null || rule.getKernelRule() == null) {
            return false;
        }
        return rule.getMultiMappings().getOrigin(element) == null;
    }

    private String[] getMultiPath(E element, Rule multiRule) {
        if (!this.isMulti(element)) {
            return null;
        }
        ArrayList<String> path = new ArrayList<String>();
        while (multiRule.isMultiRule()) {
            String name = multiRule.getName();
            path.add(name == null ? "" : name.trim());
            multiRule = multiRule.getKernelRule();
        }
        if (path.size() == 1 && ((String)path.get(0)).length() == 0) {
            return new String[0];
        }
        Collections.reverse(path);
        return path.toArray(new String[0]);
    }

    private Rule getOrCreateMultiRule(Rule root, Action action) {
        if (!action.isMulti()) {
            return null;
        }
        ArrayList<String> path = new ArrayList<String>(Arrays.asList(action.getPath()));
        if (path.isEmpty()) {
            path.add(null);
        }
        Rule rule = root.getRootRule();
        for (String name : path) {
            Rule multi = rule.getMultiRule(name);
            if (multi == null) {
                multi = HenshinFactory.eINSTANCE.createRule(name);
                if (name == null || name.trim().length() == 0) {
                    rule.getMultiRules().add(0, (Object)multi);
                } else {
                    rule.getMultiRules().add((Object)multi);
                }
            }
            new MultiRuleMapEditor(rule, multi).ensureCompleteness();
            rule = multi;
        }
        return rule;
    }

    protected NestedCondition getOrCreateAC(Action action, Rule rule) {
        if (action.getType() != Action.Type.FORBID && action.getType() != Action.Type.REQUIRE) {
            throw new IllegalArgumentException("Application conditions can be created only for REQUIRE/FORBID actions");
        }
        String name = action.getFragment();
        return this.getOrCreateAC(rule, name, action.getType() == Action.Type.REQUIRE);
    }

    protected NestedCondition getOrCreateAC(Rule rule, String name, boolean isPAC) {
        NestedCondition ac;
        NestedCondition nestedCondition = ac = isPAC ? rule.getLhs().getPAC(name) : rule.getLhs().getNAC(name);
        if (ac == null) {
            ac = isPAC ? rule.getLhs().createPAC(name) : rule.getLhs().createNAC(name);
        }
        return ac;
    }
}

