/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.model.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.henshin.HenshinModelPlugin;
import org.eclipse.emf.henshin.model.BinaryFormula;
import org.eclipse.emf.henshin.model.ConditionalUnit;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Formula;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.IteratedUnit;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.MappingList;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Parameter;
import org.eclipse.emf.henshin.model.ParameterMapping;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.UnaryFormula;
import org.eclipse.emf.henshin.model.UnaryUnit;
import org.eclipse.emf.henshin.model.Unit;
import org.eclipse.emf.henshin.model.actions.MultiRuleMapEditor;

public class HenshinModelCleaner {
    public static void cleanModule(Module module) {
        ArrayList<Unit> remove = new ArrayList<Unit>();
        do {
            remove.clear();
            for (Unit unit : module.getUnits()) {
                if (HenshinModelCleaner.cleanUnit(unit) != null) continue;
                remove.add(unit);
            }
            for (Unit unit : remove) {
                module.getUnits().remove((Object)unit);
                HenshinModelCleaner.debug("removed invalid " + unit);
            }
        } while (!remove.isEmpty());
    }

    public static Unit cleanUnit(Unit unit) {
        String iterations;
        ConditionalUnit cond;
        Unit subUnit;
        if (unit instanceof Rule) {
            HenshinModelCleaner.cleanRule((Rule)unit);
        }
        if (unit instanceof UnaryUnit && (subUnit = ((UnaryUnit)unit).getSubUnit()) == null) {
            return null;
        }
        if (unit instanceof ConditionalUnit && ((cond = (ConditionalUnit)unit).getIf() == null || cond.getThen() == null || cond.getElse() == null)) {
            return null;
        }
        if (unit instanceof IteratedUnit && ((iterations = ((IteratedUnit)unit).getIterations()) == null || iterations.trim().length() == 0)) {
            ((IteratedUnit)unit).setIterations("1");
            HenshinModelCleaner.debug("set iterations to 1 for " + unit);
        }
        HenshinModelCleaner.cleanParameterMappings(unit);
        return unit;
    }

    public static void cleanRule(Rule rule) {
        if (rule.getLhs() == null) {
            rule.setLhs(HenshinFactory.eINSTANCE.createGraph("Lhs"));
            HenshinModelCleaner.debug("added missing Lhs for " + rule);
        }
        if (rule.getRhs() == null) {
            rule.setRhs(HenshinFactory.eINSTANCE.createGraph("Rhs"));
            HenshinModelCleaner.debug("added missing Rhs for " + rule);
        }
        if (rule.getRhs().getFormula() != null) {
            rule.getRhs().setFormula(null);
            HenshinModelCleaner.debug("removed formula for Rhs of " + rule);
        }
        HenshinModelCleaner.cleanGraph(rule.getLhs());
        HenshinModelCleaner.cleanGraph(rule.getRhs());
        HenshinModelCleaner.cleanMappingList(rule.getMappings(), rule.getLhs(), rule.getRhs());
        if (rule.isMultiRule()) {
            Rule kernel = rule.getKernelRule();
            HenshinModelCleaner.cleanMappingList(rule.getMultiMappings(), kernel.getLhs(), rule.getLhs(), kernel.getRhs(), rule.getRhs());
        } else if (!rule.getMultiMappings().isEmpty()) {
            rule.getMultiMappings().clear();
            HenshinModelCleaner.debug("removed unused multi-mappings of " + rule);
        }
        for (Rule multi : rule.getMultiRules()) {
            HenshinModelCleaner.cleanRule(multi);
        }
        for (NestedCondition cond : rule.getLhs().getNestedConditions()) {
            if (!cond.isTrue() && !cond.isFalse()) continue;
            rule.getLhs().removeNestedCondition(cond);
            HenshinModelCleaner.debug("removed trivial nested condition " + cond);
        }
        Iterator iterator = rule.getMultiRules().iterator();
        while (iterator.hasNext()) {
            Rule multi;
            multi = (Rule)iterator.next();
            if (!HenshinModelCleaner.canRemoveMultiRule(multi)) continue;
            iterator.remove();
            HenshinModelCleaner.debug("removed unnecessary Multi-" + multi);
        }
        HenshinModelCleaner.synchronizeRuleParameters(rule);
    }

    public static void cleanGraph(Graph graph) {
        Iterator edges;
        for (Node node : graph.getNodes()) {
            Edge edge;
            if (node.getType() == null) {
                node.setType(EcorePackage.eINSTANCE.getEObject());
                HenshinModelCleaner.debug("setting EObject node type for " + node);
            }
            edges = node.getOutgoing().iterator();
            while (edges.hasNext()) {
                edge = (Edge)edges.next();
                if (edge.getGraph() == graph) continue;
                edges.remove();
                HenshinModelCleaner.debug("removed invalid " + edge);
            }
            edges = node.getIncoming().iterator();
            while (edges.hasNext()) {
                edge = (Edge)edges.next();
                if (edge.getGraph() == graph) continue;
                edges.remove();
                HenshinModelCleaner.debug("removed invalid " + edge);
            }
        }
        edges = graph.getEdges().iterator();
        while (edges.hasNext()) {
            Edge edge = (Edge)edges.next();
            if (edge.getSource() != null && edge.getTarget() != null && edge.getSource().getGraph() == graph && edge.getTarget().getGraph() == graph && edge.getType() != null && edge.getSource().getType().getEAllReferences().contains((Object)edge.getType())) continue;
            edges.remove();
            HenshinModelCleaner.debug("removed invalid " + edge);
        }
        graph.setFormula(HenshinModelCleaner.cleanFormula(graph.getFormula()));
    }

    public static Formula cleanFormula(Formula formula) {
        if (formula == null) {
            return null;
        }
        if (formula instanceof UnaryFormula) {
            Formula child = HenshinModelCleaner.cleanFormula(((UnaryFormula)formula).getChild());
            if (child == null) {
                return null;
            }
            return formula;
        }
        if (formula instanceof BinaryFormula) {
            BinaryFormula binary = (BinaryFormula)formula;
            Formula left = HenshinModelCleaner.cleanFormula(binary.getLeft());
            Formula right = HenshinModelCleaner.cleanFormula(binary.getRight());
            if (left == null) {
                return right;
            }
            if (right == null) {
                return left;
            }
            return binary;
        }
        if (formula instanceof NestedCondition) {
            NestedCondition condition = (NestedCondition)formula;
            HenshinModelCleaner.cleanNestedCondition(condition);
            if (condition.isTrue()) {
                return null;
            }
            return condition;
        }
        return formula;
    }

    public static void cleanNestedCondition(NestedCondition condition) {
        Graph conclusion = condition.getConclusion();
        if (conclusion == null) {
            conclusion = HenshinFactory.eINSTANCE.createGraph();
            condition.setConclusion(conclusion);
            HenshinModelCleaner.debug("created missing conclusion graph for " + condition);
        }
        HenshinModelCleaner.cleanGraph(conclusion);
        Graph host = condition.getHost();
        if (host != null) {
            HenshinModelCleaner.cleanMappingList(condition.getMappings(), host, conclusion);
        }
    }

    public static void cleanMappingList(MappingList mappings, Graph ... graphs) {
        HashMap<Graph, Graph> signatures = new HashMap<Graph, Graph>();
        for (int i = 0; i < graphs.length; i += 2) {
            signatures.put(graphs[i], graphs[i + 1]);
        }
        Iterator contents = mappings.iterator();
        while (contents.hasNext()) {
            Mapping mapping = (Mapping)contents.next();
            String msg = "removed invalid mapping " + mapping;
            if (mapping.getOrigin() == null || mapping.getImage() == null) {
                contents.remove();
                HenshinModelCleaner.debug(msg);
                continue;
            }
            Graph from = mapping.getOrigin().getGraph();
            Graph to = mapping.getImage().getGraph();
            if (from == null || to == null) {
                contents.remove();
                HenshinModelCleaner.debug(msg);
                continue;
            }
            Rule r1 = from.getRule();
            Rule r2 = to.getRule();
            if (r1 == null || r2 == null || r1 != r2 && r1.getKernelRule() != r2 && r1 != r2.getKernelRule()) {
                contents.remove();
                HenshinModelCleaner.debug(msg);
                continue;
            }
            if (signatures.get(from) != to) {
                contents.remove();
                HenshinModelCleaner.debug(msg);
                continue;
            }
            boolean unique = true;
            Iterator iterator = mappings.iterator();
            while (iterator.hasNext()) {
                Mapping other = (Mapping)iterator.next();
                Node image = other.getImage();
                if (other == mapping || other.getOrigin() != mapping.getOrigin() || image == null || image.getGraph() != to) continue;
                unique = false;
                break;
            }
            if (unique) continue;
            contents.remove();
            HenshinModelCleaner.debug(msg);
        }
    }

    public static void cleanParameterMappings(Unit unit) {
        ArrayList<Unit> validUnits = new ArrayList<Unit>();
        validUnits.add(unit);
        validUnits.addAll((Collection<Unit>)unit.getSubUnits(false));
        Iterator mappings = unit.getParameterMappings().iterator();
        while (mappings.hasNext()) {
            ParameterMapping pm = (ParameterMapping)mappings.next();
            String msg = "removed invalid parameter mapping " + pm;
            if (pm.getSource() == null || pm.getTarget() == null) {
                mappings.remove();
                HenshinModelCleaner.debug(msg);
                continue;
            }
            if (pm.getSource().getUnit() == null || pm.getTarget().getUnit() == null) {
                mappings.remove();
                HenshinModelCleaner.debug(msg);
                continue;
            }
            if (validUnits.contains(pm.getSource().getUnit()) && validUnits.contains(pm.getTarget().getUnit())) continue;
            mappings.remove();
            HenshinModelCleaner.debug(msg);
        }
    }

    public static void completeMultiRules(Module module) {
        for (Unit unit : module.getUnits()) {
            if (!(unit instanceof Rule)) continue;
            HenshinModelCleaner.completeMultiRules((Rule)unit);
        }
        for (Module subModule : module.getSubModules()) {
            HenshinModelCleaner.completeMultiRules(subModule);
        }
    }

    public static void completeMultiRules(Rule rule) {
        Rule kernel = rule.getKernelRule();
        if (kernel != null) {
            MultiRuleMapEditor editor = new MultiRuleMapEditor(kernel, rule);
            editor.ensureCompleteness();
        }
        for (Rule multiRule : rule.getMultiRules()) {
            HenshinModelCleaner.completeMultiRules(multiRule);
        }
    }

    private static boolean canRemoveMultiRule(Rule rule) {
        if (!rule.isMultiRule()) {
            return false;
        }
        for (Rule multiRule : rule.getMultiRules()) {
            if (HenshinModelCleaner.canRemoveMultiRule(multiRule)) continue;
            return false;
        }
        if (!rule.getMultiMappings().isOnto(rule.getLhs()) || !rule.getMultiMappings().isOnto(rule.getRhs())) {
            return false;
        }
        for (NestedCondition nestedCond : rule.getLhs().getNestedConditions()) {
            if (nestedCond.isTrue()) continue;
            return false;
        }
        return true;
    }

    private static void debug(String message) {
        HenshinModelPlugin.INSTANCE.logInfo("CleanUp: " + message);
    }

    public static void synchronizeRuleParameters(Rule rule) {
        LinkedHashMap<String, Parameter> parameters = new LinkedHashMap<String, Parameter>();
        HenshinModelCleaner.collectRuleParameters(rule, parameters);
        HenshinModelCleaner.updateRuleParameters(rule, parameters);
    }

    private static void collectRuleParameters(Rule rule, Map<String, Parameter> parameters) {
        for (Parameter param : rule.getParameters()) {
            if (param.getName() == null) continue;
            parameters.put(param.getName(), param);
        }
        for (Rule multiRule : rule.getMultiRules()) {
            HenshinModelCleaner.collectRuleParameters(multiRule, parameters);
        }
    }

    private static void updateRuleParameters(Rule rule, Map<String, Parameter> parameters) {
        ArrayList<Parameter> paramList = new ArrayList<Parameter>(parameters.values());
        while (rule.getParameters().size() < paramList.size()) {
            rule.getParameters().add((Object)HenshinFactory.eINSTANCE.createParameter());
        }
        while (rule.getParameters().size() > paramList.size()) {
            rule.getParameters().remove(rule.getParameters().size() - 1);
        }
        for (int i = 0; i < paramList.size(); ++i) {
            Parameter s = (Parameter)paramList.get(i);
            Parameter t = (Parameter)rule.getParameters().get(i);
            t.setName(s.getName());
            t.setType(s.getType());
            t.setDescription(s.getDescription());
        }
        for (Rule multiRule : rule.getMultiRules()) {
            HenshinModelCleaner.updateRuleParameters(multiRule, parameters);
        }
    }
}

