/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.servicecutter.api;

import ch.hsr.servicecutter.api.ServiceCutterContext;
import ch.hsr.servicecutter.api.SolverConfigurationFactory;
import ch.hsr.servicecutter.api.model.Characteristic;
import ch.hsr.servicecutter.api.model.Compatibilities;
import ch.hsr.servicecutter.api.model.Entity;
import ch.hsr.servicecutter.api.model.EntityRelation;
import ch.hsr.servicecutter.api.model.EntityRelationDiagram;
import ch.hsr.servicecutter.api.model.RelatedGroup;
import ch.hsr.servicecutter.api.model.UseCase;
import ch.hsr.servicecutter.api.model.UserRepresentationContainer;
import ch.hsr.servicecutter.model.criteria.CouplingCriterion;
import ch.hsr.servicecutter.model.criteria.CouplingCriterionCharacteristic;
import ch.hsr.servicecutter.model.criteria.CouplingType;
import ch.hsr.servicecutter.model.usersystem.CouplingInstance;
import ch.hsr.servicecutter.model.usersystem.InstanceType;
import ch.hsr.servicecutter.model.usersystem.Nanoentity;
import ch.hsr.servicecutter.solver.SolverConfiguration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceCutterContextBuilder {
    private final Logger log = LoggerFactory.getLogger(ServiceCutterContextBuilder.class);
    private ServiceCutterContext context;
    private EntityRelationDiagram entityRelationDiagram;
    private UserRepresentationContainer userRepresentationContainer;
    private SolverConfiguration solverConfiguration;

    public ServiceCutterContextBuilder(EntityRelationDiagram entityRelationDiagram) {
        this.entityRelationDiagram = entityRelationDiagram;
    }

    public ServiceCutterContextBuilder withUserRepresentations(UserRepresentationContainer userRepresentations) {
        this.userRepresentationContainer = userRepresentations;
        return this;
    }

    public ServiceCutterContextBuilder withCustomSolverConfiguration(SolverConfiguration solverConfiguration) {
        this.solverConfiguration = solverConfiguration;
        return this;
    }

    public ServiceCutterContext build() {
        this.context = new ServiceCutterContext(this.entityRelationDiagram.getName());
        this.initSolverConfiguration();
        this.initERDRelatedData();
        this.initUserRepresentationRelatedData();
        return this.context;
    }

    private void initSolverConfiguration() {
        if (this.solverConfiguration == null) {
            this.context.setSolverConfiguration(new SolverConfigurationFactory().createDefaultConfiguration());
        } else {
            this.context.setSolverConfiguration(this.solverConfiguration);
        }
    }

    private void initERDRelatedData() {
        String name = this.entityRelationDiagram.getName();
        List<TemporaryNanoentity> nanoentities = this.entityRelationDiagram.getEntities().stream().flatMap(e -> e.getNanoentities().stream().map(n -> new TemporaryNanoentity(e.getName(), (String)n))).collect(Collectors.toList());
        CouplingCriterion criterion = this.context.getCriteriaCatalog().getCriterionByName("Identity & Lifecycle Commonality");
        Map<String, List<TemporaryNanoentity>> nanoentitiesByEntity = this.expandEntitiesByCompositionAndInheritance(this.entityRelationDiagram, nanoentities).stream().collect(Collectors.groupingBy(TemporaryNanoentity::getNewEntity));
        for (Map.Entry<String, List<TemporaryNanoentity>> entityAndNanoentities : nanoentitiesByEntity.entrySet()) {
            CouplingInstance entityCoupling = new CouplingInstance(criterion, InstanceType.SAME_ENTITY);
            this.context.addCouplingInstance(entityCoupling);
            entityCoupling.setName(entityAndNanoentities.getKey());
            for (TemporaryNanoentity newNanoentity : entityAndNanoentities.getValue()) {
                entityCoupling.addNanoentity(this.createNanoentity(newNanoentity.getOriginalEntity(), newNanoentity.getOriginalName()));
            }
        }
        CouplingCriterion semanticProximity = this.context.getCriteriaCatalog().getCriterionByName("Semantic Proximity");
        for (EntityRelation relation : this.entityRelationDiagram.getRelations()) {
            if (!EntityRelation.RelationType.AGGREGATION.equals((Object)relation.getType())) continue;
            CouplingInstance instance = new CouplingInstance(semanticProximity, InstanceType.AGGREGATION);
            List<Nanoentity> originNanoentities = relation.getOrigin().getNanoentities().stream().map(attr -> this.context.findNanoEntityByContextAndName(relation.getOrigin().getName(), (String)attr)).collect(Collectors.toList());
            List<Nanoentity> destinationNanoentities = relation.getDestination().getNanoentities().stream().map(attr -> this.context.findNanoEntityByContextAndName(relation.getDestination().getName(), (String)attr)).collect(Collectors.toList());
            instance.setNanoentities(originNanoentities);
            instance.setSecondNanoentities(destinationNanoentities);
            instance.setName(relation.getOrigin().getName() + "." + relation.getDestination().getName());
            this.context.addCouplingInstance(instance);
        }
    }

    private void initUserRepresentationRelatedData() {
        if (this.userRepresentationContainer == null) {
            return;
        }
        this.createUseCaseCouplingInstances(this.userRepresentationContainer.getUseCases());
        Compatibilities compatibilities = this.userRepresentationContainer.getCompatibilities();
        if (compatibilities != null) {
            this.createCharacteristicCouplingInstances(compatibilities.getStructuralVolatility(), "Structural Volatility");
            this.createCharacteristicCouplingInstances(compatibilities.getConsistencyCriticality(), "Consistency Criticality");
            this.createCharacteristicCouplingInstances(compatibilities.getSecurityCriticality(), "Security Criticality");
            this.createCharacteristicCouplingInstances(compatibilities.getStorageSimilarity(), "Storage Similarity");
            this.createCharacteristicCouplingInstances(compatibilities.getContentVolatility(), "Content Volatility");
            this.createCharacteristicCouplingInstances(compatibilities.getAvailabilityCriticality(), "Availability Criticality");
        }
        this.createRelatedGroupCouplingInstances(this.userRepresentationContainer.getAggregates(), "Consistency Constraint");
        this.createRelatedGroupCouplingInstances(this.userRepresentationContainer.getEntities(), "Identity & Lifecycle Commonality");
        this.createRelatedGroupCouplingInstances(this.userRepresentationContainer.getPredefinedServices(), "Predefined Service Constraint");
        this.createRelatedGroupCouplingInstances(this.userRepresentationContainer.getSecurityAccessGroups(), "Security Contextuality");
        this.createRelatedGroupCouplingInstances(this.userRepresentationContainer.getSeparatedSecurityZones(), "Security Constraint");
        this.createRelatedGroupCouplingInstances(this.userRepresentationContainer.getSharedOwnerGroups(), "Shared Owner");
    }

    private void createUseCaseCouplingInstances(List<UseCase> useCases) {
        CouplingCriterion semanticProximity = this.context.getCriteriaCatalog().getCriterionByName("Semantic Proximity");
        for (UseCase usecase : useCases) {
            InstanceType type = usecase.isLatencyCritical() ? InstanceType.LATENCY_USE_CASE : InstanceType.USE_CASE;
            CouplingInstance instance = new CouplingInstance(semanticProximity, type);
            instance.setName(usecase.getName());
            instance.setNanoentities(this.findNanoentities(usecase.getNanoentitiesRead()));
            instance.setSecondNanoentities(this.findNanoentities(usecase.getNanoentitiesWritten()));
            this.context.addCouplingInstance(instance);
            this.log.info("Import use cases {} with fields written {} and fields read {}", new Object[]{usecase.getName(), usecase.getNanoentitiesWritten(), usecase.getNanoentitiesRead()});
        }
    }

    private void createCharacteristicCouplingInstances(List<Characteristic> characteristics, String criterionName) {
        if (characteristics == null || characteristics.isEmpty()) {
            return;
        }
        for (Characteristic inputCharacteristic : characteristics) {
            CouplingCriterionCharacteristic characteristic = this.findCharacteristic(criterionName, inputCharacteristic.getCharacteristic());
            if (characteristic == null) {
                this.log.error("characteristic {} not known! ignoring...", (Object)inputCharacteristic);
                continue;
            }
            Set<CouplingInstance> instance = this.context.findCouplingInstancesByCharacteristic(characteristic);
            if (instance == null || instance.isEmpty()) {
                CouplingInstance newInstance = new CouplingInstance(characteristic, InstanceType.CHARACTERISTIC);
                newInstance.setName(criterionName);
                newInstance.setNanoentities(this.findNanoentities(inputCharacteristic.getNanoentities()));
                this.context.addCouplingInstance(newInstance);
                this.log.info("Import distance characteristic {}-{} with nanoentities {}", new Object[]{criterionName, inputCharacteristic.getCharacteristic(), newInstance.getAllNanoentities()});
                continue;
            }
            this.log.error("enhancing characteristics not yet implemented. criterion: {}, characteristic: {}", (Object)criterionName, (Object)inputCharacteristic.getCharacteristic());
        }
        this.completeSystemWithDefaultsForDistance();
    }

    private void createRelatedGroupCouplingInstances(List<RelatedGroup> listOfGroups, String couplingCriterionName) {
        if (listOfGroups == null || listOfGroups.isEmpty()) {
            return;
        }
        CouplingCriterion couplingCriterion = this.context.getCriteriaCatalog().getCriterionByName(couplingCriterionName);
        for (RelatedGroup relatedGroup : listOfGroups) {
            CouplingInstance instance = new CouplingInstance(couplingCriterion, InstanceType.RELATED_GROUP);
            String name = relatedGroup.getName();
            instance.setName(name != null && !"".equals(name) ? name : couplingCriterionName);
            instance.setNanoentities(this.findNanoentities(relatedGroup.getNanoentities()));
            this.context.addCouplingInstance(instance);
            this.log.info("Import related group {} on nanoentities {} ", (Object)name, instance.getNanoentities());
        }
    }

    private CouplingCriterionCharacteristic findCharacteristic(String coupling, String characteristic) {
        CouplingCriterion couplingCriterion = this.context.getCriteriaCatalog().getCriterionByName(coupling);
        CouplingCriterionCharacteristic result = this.context.getCriteriaCatalog().getCouplingCriterionCharacteristicByNameAndCouplingCriterion(characteristic, couplingCriterion);
        return result;
    }

    private List<Nanoentity> findNanoentities(List<String> names) {
        ArrayList<Nanoentity> nanoentities = new ArrayList<Nanoentity>();
        for (String nanoentityName : names) {
            Nanoentity nanoentity;
            if (nanoentityName.contains(".")) {
                String[] splittedName = nanoentityName.split("\\.");
                nanoentity = this.context.findNanoEntityByContextAndName(splittedName[0], splittedName[1]);
            } else {
                nanoentity = this.context.findNanoEntityByName(nanoentityName);
            }
            if (nanoentity != null) {
                nanoentities.add(nanoentity);
                continue;
            }
            this.log.warn("nanoentity with name {} not known!", (Object)nanoentityName);
        }
        return nanoentities;
    }

    private Nanoentity createNanoentity(String context, String name) {
        Nanoentity nanoentity = new Nanoentity();
        nanoentity.setName(name);
        nanoentity.setContext(context);
        this.context.addNanoEntity(nanoentity);
        return nanoentity;
    }

    private List<TemporaryNanoentity> expandEntitiesByCompositionAndInheritance(EntityRelationDiagram erd, List<TemporaryNanoentity> nanoentities) {
        ArrayList<EntityRelation> currentRelations = new ArrayList<EntityRelation>(erd.getRelations());
        List<EntityRelation> relationsToEdgeEntities = this.getRelationsToEdgeEntities(currentRelations, erd.getEntities());
        while (!relationsToEdgeEntities.isEmpty()) {
            for (EntityRelation relation : relationsToEdgeEntities) {
                String destinationEntity = relation.getDestination().getName();
                String originEntity = relation.getOrigin().getName();
                if (EntityRelation.RelationType.COMPOSITION.equals((Object)relation.getType())) {
                    nanoentities.stream().filter(n -> destinationEntity.equals(n.getOriginalEntity())).forEach(n -> n.setNewEntity(originEntity));
                } else if (EntityRelation.RelationType.INHERITANCE.equals((Object)relation.getType())) {
                    nanoentities.stream().filter(n -> originEntity.equals(n.getOriginalEntity())).forEach(n -> n.setNewEntity(destinationEntity));
                }
                currentRelations.remove(relation);
                relationsToEdgeEntities = this.getRelationsToEdgeEntities(currentRelations, erd.getEntities());
            }
        }
        return nanoentities;
    }

    private List<EntityRelation> getRelationsToEdgeEntities(List<EntityRelation> currentRelations, List<Entity> inputEntites) {
        List reducableEntities = inputEntites.stream().filter(entity -> currentRelations.stream().filter(r2 -> r2.getDestination().equals(entity) && r2.getType().equals((Object)EntityRelation.RelationType.INHERITANCE) || r2.getOrigin().equals(entity) && r2.getType().equals((Object)EntityRelation.RelationType.COMPOSITION)).collect(Collectors.toList()).isEmpty()).collect(Collectors.toList());
        List<EntityRelation> relationsToEdgeEntities = currentRelations.stream().filter(r -> reducableEntities.contains(r.getOrigin()) && r.getType().equals((Object)EntityRelation.RelationType.INHERITANCE) || reducableEntities.contains(r.getDestination()) && r.getType().equals((Object)EntityRelation.RelationType.COMPOSITION)).collect(Collectors.toList());
        return relationsToEdgeEntities;
    }

    public void completeSystemWithDefaultsForDistance() {
        Set<Nanoentity> allNanoentitiesInModel = this.context.getNanoEntities();
        Map<String, Set<CouplingInstance>> instancesByCriterion = this.context.findCouplingInstancesGroupedByCriterionFilteredByCriterionType(CouplingType.COMPATIBILITY);
        for (Map.Entry<String, Set<CouplingInstance>> criterion : instancesByCriterion.entrySet()) {
            CouplingInstance instance2;
            Set definedNanoentities = criterion.getValue().stream().flatMap(instance -> instance.getAllNanoentities().stream()).collect(Collectors.toSet());
            Set missingNanoentities = allNanoentitiesInModel.stream().filter(nanoentity -> !definedNanoentities.contains(nanoentity)).collect(Collectors.toSet());
            if (missingNanoentities.isEmpty()) continue;
            CouplingCriterionCharacteristic defaultCharacteristic = this.context.getCriteriaCatalog().getCouplingCriterionCharacteristicByCouplingCriterionAndIsDefault(this.context.getCriteriaCatalog().getCriterionByName(criterion.getKey()));
            Set<CouplingInstance> instances = this.context.findCouplingInstancesByCharacteristic(defaultCharacteristic);
            if (instances.size() == 1) {
                instance2 = instances.iterator().next();
            } else if (instances.size() == 0) {
                instance2 = new CouplingInstance(defaultCharacteristic, InstanceType.CHARACTERISTIC);
                instance2.setName(defaultCharacteristic.getName());
                this.context.addCouplingInstance(instance2);
            } else {
                throw new RuntimeException("only one instance per characteristic expected for distance criterion");
            }
            for (Nanoentity nanoentity2 : missingNanoentities) {
                instance2.addNanoentity(nanoentity2);
            }
            this.log.info("Complete model with instance of characteristic {} of criterion {} and nanoentities {}", new Object[]{defaultCharacteristic.getName(), criterion.getKey(), missingNanoentities});
        }
    }

    private class TemporaryNanoentity {
        private String originalEntity;
        private String originalName;
        private String newEntity;

        public TemporaryNanoentity(String originalEntity, String originalName) {
            this.originalEntity = originalEntity;
            this.originalName = originalName;
            this.newEntity = originalEntity;
        }

        public String getOriginalEntity() {
            return this.originalEntity;
        }

        public String getOriginalName() {
            return this.originalName;
        }

        public String getNewEntity() {
            return this.newEntity;
        }

        public void setNewEntity(String newEntity) {
            this.newEntity = newEntity;
        }
    }
}

