/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream;

import org.graphstream.graph.Edge;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.stream.Source;
import org.graphstream.stream.SourceBase;

public class GraphReplay
extends SourceBase
implements Source {
    public GraphReplay(String id) {
        super(id);
    }

    public void replay(Graph graph) {
        for (String key : graph.getAttributeKeySet()) {
            this.sendGraphAttributeAdded(this.sourceId, key, graph.getAttribute(key));
        }
        for (Node node : graph) {
            String nodeId = node.getId();
            this.sendNodeAdded(this.sourceId, nodeId);
            if (node.getAttributeCount() <= 0) continue;
            for (String key : node.getAttributeKeySet()) {
                this.sendNodeAttributeAdded(this.sourceId, nodeId, key, node.getAttribute(key));
            }
        }
        for (Edge edge : graph.getEachEdge()) {
            String edgeId = edge.getId();
            this.sendEdgeAdded(this.sourceId, edgeId, edge.getNode0().getId(), edge.getNode1().getId(), edge.isDirected());
            if (edge.getAttributeCount() <= 0) continue;
            for (String key : edge.getAttributeKeySet()) {
                this.sendEdgeAttributeAdded(this.sourceId, edgeId, key, edge.getAttribute(key));
            }
        }
    }
}

