/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.netstream;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.graphstream.stream.Sink;
import org.graphstream.stream.netstream.NetStreamConstants;
import org.graphstream.stream.netstream.packing.NetStreamPacker;

public class NetStreamSender
implements Sink {
    private static ByteBuffer NULL_BUFFER = ByteBuffer.allocate(0);
    protected String stream;
    protected ByteBuffer streamBuffer;
    byte[] streamIdArray;
    protected String host;
    protected int port;
    protected Socket socket;
    protected BufferedOutputStream out;
    protected String sourceId = "";
    protected ByteBuffer sourceIdBuff;
    protected NetStreamPacker packer = new DefaultPacker();

    public NetStreamSender(String host, int port) throws UnknownHostException, IOException {
        this("default", host, port);
    }

    public NetStreamSender(int port) throws UnknownHostException, IOException {
        this("default", "localhost", port);
    }

    public NetStreamSender(String stream, String host, int port) throws UnknownHostException, IOException {
        this.stream = stream;
        this.host = host;
        this.port = port;
        this.setStream(stream);
        this.connect();
    }

    public void setStream(String stream) {
        this.streamIdArray = stream.getBytes(Charset.forName("UTF-8"));
        this.streamBuffer = this.encodeString(stream);
    }

    public NetStreamSender(Socket socket) throws IOException {
        this("default", socket);
    }

    public NetStreamSender(String stream, Socket socket) throws IOException {
        this.host = socket.getInetAddress().getHostName();
        this.port = socket.getPort();
        this.socket = socket;
        this.out = new BufferedOutputStream(socket.getOutputStream());
        this.streamIdArray = stream.getBytes(Charset.forName("UTF-8"));
    }

    public void setPacker(NetStreamPacker paker) {
        this.packer = paker;
    }

    public void removePacker() {
        this.packer = new DefaultPacker();
    }

    protected void connect() throws UnknownHostException, IOException {
        this.socket = new Socket(this.host, this.port);
        this.out = new BufferedOutputStream(this.socket.getOutputStream());
    }

    protected int getType(Object value) {
        int valueType = NetStreamConstants.TYPE_UNKNOWN;
        if (value == null) {
            return NetStreamConstants.TYPE_NULL;
        }
        Class<?> valueClass = value.getClass();
        boolean isArray = valueClass.isArray();
        if (isArray) {
            valueClass = ((Object[])value)[0].getClass();
        }
        if (valueClass.equals(Boolean.class)) {
            valueType = isArray ? NetStreamConstants.TYPE_BOOLEAN_ARRAY : NetStreamConstants.TYPE_BOOLEAN;
        } else if (valueClass.equals(Byte.class)) {
            valueType = isArray ? NetStreamConstants.TYPE_BYTE_ARRAY : NetStreamConstants.TYPE_BYTE;
        } else if (valueClass.equals(Short.class)) {
            valueType = isArray ? NetStreamConstants.TYPE_SHORT_ARRAY : NetStreamConstants.TYPE_SHORT;
        } else if (valueClass.equals(Integer.class)) {
            valueType = isArray ? NetStreamConstants.TYPE_INT_ARRAY : NetStreamConstants.TYPE_INT;
        } else if (valueClass.equals(Long.class)) {
            valueType = isArray ? NetStreamConstants.TYPE_LONG_ARRAY : NetStreamConstants.TYPE_LONG;
        } else if (valueClass.equals(Float.class)) {
            valueType = isArray ? NetStreamConstants.TYPE_FLOAT_ARRAY : NetStreamConstants.TYPE_FLOAT;
        } else if (valueClass.equals(Double.class)) {
            valueType = isArray ? NetStreamConstants.TYPE_DOUBLE_ARRAY : NetStreamConstants.TYPE_DOUBLE;
        } else if (valueClass.equals(String.class)) {
            valueType = isArray ? (int)NetStreamConstants.TYPE_ARRAY : NetStreamConstants.TYPE_STRING;
        } else {
            System.err.printf("[warning] can not find type of %s\n", valueClass);
        }
        return valueType;
    }

    protected ByteBuffer encodeValue(Object in, int valueType) {
        if (NetStreamConstants.TYPE_BOOLEAN == valueType) {
            return this.encodeBoolean(in);
        }
        if (NetStreamConstants.TYPE_BOOLEAN_ARRAY == valueType) {
            return this.encodeBooleanArray(in);
        }
        if (NetStreamConstants.TYPE_BYTE == valueType) {
            return this.encodeByte(in);
        }
        if (NetStreamConstants.TYPE_BYTE_ARRAY == valueType) {
            return this.encodeByteArray(in);
        }
        if (NetStreamConstants.TYPE_SHORT == valueType) {
            return this.encodeShort(in);
        }
        if (NetStreamConstants.TYPE_SHORT_ARRAY == valueType) {
            return this.encodeShortArray(in);
        }
        if (NetStreamConstants.TYPE_INT == valueType) {
            return this.encodeInt(in);
        }
        if (NetStreamConstants.TYPE_INT_ARRAY == valueType) {
            return this.encodeIntArray(in);
        }
        if (NetStreamConstants.TYPE_LONG == valueType) {
            return this.encodeLong(in);
        }
        if (NetStreamConstants.TYPE_LONG_ARRAY == valueType) {
            return this.encodeLongArray(in);
        }
        if (NetStreamConstants.TYPE_FLOAT == valueType) {
            return this.encodeFloat(in);
        }
        if (NetStreamConstants.TYPE_FLOAT_ARRAY == valueType) {
            return this.encodeFloatArray(in);
        }
        if (NetStreamConstants.TYPE_DOUBLE == valueType) {
            return this.encodeDouble(in);
        }
        if (NetStreamConstants.TYPE_DOUBLE_ARRAY == valueType) {
            return this.encodeDoubleArray(in);
        }
        if (NetStreamConstants.TYPE_STRING == valueType) {
            return this.encodeString(in);
        }
        if (NetStreamConstants.TYPE_ARRAY == valueType) {
            return this.encodeArray(in);
        }
        if (NetStreamConstants.TYPE_NULL == valueType) {
            return NULL_BUFFER;
        }
        System.err.printf("[warning] unknown value type %d\n", valueType);
        return null;
    }

    protected ByteBuffer encodeArray(Object in) {
        return null;
    }

    protected ByteBuffer encodeString(Object in) {
        String s = (String)in;
        byte[] data = s.getBytes(Charset.forName("UTF-8"));
        ByteBuffer lenBuff = this.encodeUnsignedVarint(data.length);
        ByteBuffer bb = ByteBuffer.allocate(lenBuff.capacity() + data.length);
        bb.put(lenBuff).put(data);
        bb.rewind();
        return bb;
    }

    protected ByteBuffer encodeDoubleArray(Object in) {
        Object[] data = (Object[])in;
        int ssize = this.varintSize(data.length);
        ByteBuffer b = ByteBuffer.allocate(ssize + data.length * 8);
        this.putVarint(b, data.length, ssize);
        for (int i = 0; i < data.length; ++i) {
            b.putDouble((Double)data[i]);
        }
        b.rewind();
        return b;
    }

    protected ByteBuffer encodeDouble(Object in) {
        ByteBuffer bb = ByteBuffer.allocate(8).putDouble((Double)in);
        bb.rewind();
        return bb;
    }

    protected ByteBuffer encodeFloatArray(Object in) {
        Object[] data = (Object[])in;
        int ssize = this.varintSize(data.length);
        ByteBuffer b = ByteBuffer.allocate(ssize + data.length * 4);
        this.putVarint(b, data.length, ssize);
        for (int i = 0; i < data.length; ++i) {
            b.putFloat(((Float)data[i]).floatValue());
        }
        b.rewind();
        return b;
    }

    protected ByteBuffer encodeFloat(Object in) {
        ByteBuffer b = ByteBuffer.allocate(4);
        b.putFloat(((Float)in).floatValue());
        b.rewind();
        return b;
    }

    protected ByteBuffer encodeLongArray(Object in) {
        return this.encodeVarintArray(in);
    }

    protected ByteBuffer encodeLong(Object in) {
        return this.encodeVarint(in);
    }

    protected ByteBuffer encodeIntArray(Object in) {
        return this.encodeVarintArray(in);
    }

    protected ByteBuffer encodeInt(Object in) {
        return this.encodeVarint(in);
    }

    protected ByteBuffer encodeShortArray(Object in) {
        return this.encodeVarintArray(in);
    }

    protected ByteBuffer encodeShort(Object in) {
        return this.encodeVarint(in);
    }

    protected ByteBuffer encodeByteArray(Object in) {
        Object[] data = (Object[])in;
        int ssize = this.varintSize(data.length);
        ByteBuffer b = ByteBuffer.allocate(ssize + data.length);
        this.putVarint(b, data.length, ssize);
        for (int i = 0; i < data.length; ++i) {
            b.put((Byte)data[i]);
        }
        b.rewind();
        return b;
    }

    protected ByteBuffer encodeByte(Object in) {
        ByteBuffer b = ByteBuffer.allocate(1);
        b.put((Byte)in);
        b.rewind();
        return b;
    }

    protected ByteBuffer encodeBooleanArray(Object in) {
        Object[] data = (Object[])in;
        int ssize = this.varintSize(data.length);
        ByteBuffer b = ByteBuffer.allocate(ssize + data.length);
        this.putVarint(b, data.length, ssize);
        for (int i = 0; i < data.length; ++i) {
            b.put((byte)((Boolean)data[i] != false ? 1 : 0));
        }
        b.rewind();
        return b;
    }

    protected ByteBuffer encodeBoolean(Object in) {
        ByteBuffer b = ByteBuffer.allocate(1);
        b.put((byte)((Boolean)in != false ? 1 : 0));
        b.rewind();
        return b;
    }

    private int varintSize(long data) {
        if (data < 128L) {
            return 1;
        }
        if (data < 16384L) {
            return 2;
        }
        if (data < 0x200000L) {
            return 3;
        }
        if (data < 0x10000000L) {
            return 4;
        }
        if (data < 0x800000000L) {
            return 5;
        }
        if (data < 0x40000000000L) {
            return 6;
        }
        if (data < 0x2000000000000L) {
            return 7;
        }
        if (data < 0x100000000000000L) {
            return 8;
        }
        return 9;
    }

    protected ByteBuffer encodeVarint(Object in) {
        long data = ((Number)in).longValue();
        return this.encodeUnsignedVarint(data >= 0L ? data << 1 : Math.abs(data) << 1 ^ 1L);
    }

    protected ByteBuffer encodeVarintArray(Object in) {
        Object[] data = (Object[])in;
        int[] sizes = new int[data.length];
        long[] zigzags = new long[data.length];
        int sumsizes = 0;
        for (int i = 0; i < data.length; ++i) {
            long datum = ((Number)data[i]).longValue();
            zigzags[i] = datum > 0L ? datum << 1 : Math.abs(datum) << 1 ^ 1L;
            sizes[i] = this.varintSize(zigzags[i]);
            sumsizes += sizes[i];
        }
        int ssize = this.varintSize(data.length);
        ByteBuffer b = ByteBuffer.allocate(ssize + sumsizes);
        this.putVarint(b, data.length, ssize);
        for (int i = 0; i < data.length; ++i) {
            this.putVarint(b, zigzags[i], sizes[i]);
        }
        b.rewind();
        return b;
    }

    protected ByteBuffer encodeUnsignedVarint(Object in) {
        long data = ((Number)in).longValue();
        int size = this.varintSize(data);
        ByteBuffer buff = ByteBuffer.allocate(size);
        for (int i = 0; i < size; ++i) {
            int head = 128;
            if (i == size - 1) {
                head = 0;
            }
            long b = data >> 7 * i & 0x7FL ^ (long)head;
            buff.put((byte)(b & 0xFFL));
        }
        buff.rewind();
        return buff;
    }

    private void putVarint(ByteBuffer buffer, long number, int byteSize) {
        for (int i = 0; i < byteSize; ++i) {
            int head = 128;
            if (i == byteSize - 1) {
                head = 0;
            }
            long b = number >> 7 * i & 0x7FL ^ (long)head;
            buffer.put((byte)(b & 0xFFL));
        }
    }

    private void doSend(ByteBuffer buff) {
        if (this.socket.isClosed()) {
            System.err.println("NetStreamSender : can't send. The socket is closed.");
        } else {
            buff.rewind();
            ByteBuffer buffer = this.packer.packMessage(buff);
            ByteBuffer sizeBuffer = this.packer.packMessageSize(buffer.capacity());
            try {
                this.out.write(sizeBuffer.array(), 0, sizeBuffer.capacity());
                this.out.write(buffer.array(), 0, buffer.capacity());
                this.out.flush();
            }
            catch (IOException e) {
                try {
                    this.socket.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                System.err.printf("socket error : %s\n", e.getMessage());
            }
        }
    }

    @Override
    public void graphAttributeAdded(String sourceId, long timeId, String attribute, Object value) {
        if (!sourceId.equals(this.sourceId)) {
            this.sourceId = sourceId;
            this.sourceIdBuff = this.encodeString(sourceId);
        }
        ByteBuffer attrBuff = this.encodeString(attribute);
        int valueType = this.getType(value);
        ByteBuffer valueBuff = this.encodeValue(value, valueType);
        ByteBuffer buff = ByteBuffer.allocate(this.streamBuffer.capacity() + 1 + this.sourceIdBuff.capacity() + this.varintSize(timeId) + attrBuff.capacity() + 1 + valueBuff.capacity());
        this.streamBuffer.rewind();
        this.sourceIdBuff.rewind();
        buff.put(this.streamBuffer).put((byte)NetStreamConstants.EVENT_ADD_GRAPH_ATTR).put(this.sourceIdBuff).put(this.encodeUnsignedVarint(timeId)).put(attrBuff).put((byte)valueType).put(valueBuff);
        this.doSend(buff);
    }

    @Override
    public void graphAttributeChanged(String sourceId, long timeId, String attribute, Object oldValue, Object newValue) {
        if (!sourceId.equals(this.sourceId)) {
            this.sourceId = sourceId;
            this.sourceIdBuff = this.encodeString(sourceId);
        }
        ByteBuffer attrBuff = this.encodeString(attribute);
        int oldValueType = this.getType(oldValue);
        int newValueType = this.getType(newValue);
        ByteBuffer oldValueBuff = this.encodeValue(oldValue, oldValueType);
        ByteBuffer newValueBuff = this.encodeValue(newValue, newValueType);
        ByteBuffer buff = ByteBuffer.allocate(this.streamBuffer.capacity() + 1 + this.sourceIdBuff.capacity() + this.varintSize(timeId) + attrBuff.capacity() + 1 + oldValueBuff.capacity() + 1 + newValueBuff.capacity());
        this.streamBuffer.rewind();
        this.sourceIdBuff.rewind();
        buff.put(this.streamBuffer).put((byte)NetStreamConstants.EVENT_CHG_GRAPH_ATTR).put(this.sourceIdBuff).put(this.encodeUnsignedVarint(timeId)).put(attrBuff).put((byte)oldValueType).put(oldValueBuff).put((byte)newValueType).put(newValueBuff);
        this.doSend(buff);
    }

    @Override
    public void graphAttributeRemoved(String sourceId, long timeId, String attribute) {
        if (!sourceId.equals(this.sourceId)) {
            this.sourceId = sourceId;
            this.sourceIdBuff = this.encodeString(sourceId);
        }
        ByteBuffer attrBuff = this.encodeString(attribute);
        ByteBuffer buff = ByteBuffer.allocate(this.streamBuffer.capacity() + 1 + this.sourceIdBuff.capacity() + this.varintSize(timeId) + attrBuff.capacity());
        this.streamBuffer.rewind();
        this.sourceIdBuff.rewind();
        buff.put(this.streamBuffer).put((byte)NetStreamConstants.EVENT_DEL_GRAPH_ATTR).put(this.sourceIdBuff).put(this.encodeUnsignedVarint(timeId)).put(attrBuff);
        this.doSend(buff);
    }

    @Override
    public void nodeAttributeAdded(String sourceId, long timeId, String nodeId, String attribute, Object value) {
        if (!sourceId.equals(this.sourceId)) {
            this.sourceId = sourceId;
            this.sourceIdBuff = this.encodeString(sourceId);
        }
        ByteBuffer nodeBuff = this.encodeString(nodeId);
        ByteBuffer attrBuff = this.encodeString(attribute);
        int valueType = this.getType(value);
        ByteBuffer valueBuff = this.encodeValue(value, valueType);
        ByteBuffer buff = ByteBuffer.allocate(this.streamBuffer.capacity() + 1 + this.sourceIdBuff.capacity() + this.varintSize(timeId) + nodeBuff.capacity() + attrBuff.capacity() + 1 + valueBuff.capacity());
        this.streamBuffer.rewind();
        this.sourceIdBuff.rewind();
        buff.put(this.streamBuffer).put((byte)NetStreamConstants.EVENT_ADD_NODE_ATTR).put(this.sourceIdBuff).put(this.encodeUnsignedVarint(timeId)).put(nodeBuff).put(attrBuff).put((byte)valueType).put(valueBuff);
        this.doSend(buff);
    }

    @Override
    public void nodeAttributeChanged(String sourceId, long timeId, String nodeId, String attribute, Object oldValue, Object newValue) {
        if (!sourceId.equals(this.sourceId)) {
            this.sourceId = sourceId;
            this.sourceIdBuff = this.encodeString(sourceId);
        }
        ByteBuffer nodeBuff = this.encodeString(nodeId);
        ByteBuffer attrBuff = this.encodeString(attribute);
        int oldValueType = this.getType(oldValue);
        int newValueType = this.getType(newValue);
        ByteBuffer oldValueBuff = this.encodeValue(oldValue, oldValueType);
        ByteBuffer newValueBuff = this.encodeValue(newValue, newValueType);
        ByteBuffer buff = ByteBuffer.allocate(this.streamBuffer.capacity() + 1 + this.sourceIdBuff.capacity() + this.varintSize(timeId) + nodeBuff.capacity() + attrBuff.capacity() + 1 + oldValueBuff.capacity() + 1 + newValueBuff.capacity());
        this.streamBuffer.rewind();
        this.sourceIdBuff.rewind();
        buff.put(this.streamBuffer).put((byte)NetStreamConstants.EVENT_CHG_NODE_ATTR).put(this.sourceIdBuff).put(this.encodeUnsignedVarint(timeId)).put(nodeBuff).put(attrBuff).put((byte)oldValueType).put(oldValueBuff).put((byte)newValueType).put(newValueBuff);
        this.doSend(buff);
    }

    @Override
    public void nodeAttributeRemoved(String sourceId, long timeId, String nodeId, String attribute) {
        if (!sourceId.equals(this.sourceId)) {
            this.sourceId = sourceId;
            this.sourceIdBuff = this.encodeString(sourceId);
        }
        ByteBuffer nodeBuff = this.encodeString(nodeId);
        ByteBuffer attrBuff = this.encodeString(attribute);
        ByteBuffer buff = ByteBuffer.allocate(this.streamBuffer.capacity() + 1 + this.sourceIdBuff.capacity() + this.varintSize(timeId) + nodeBuff.capacity() + attrBuff.capacity());
        this.streamBuffer.rewind();
        this.sourceIdBuff.rewind();
        buff.put(this.streamBuffer).put((byte)NetStreamConstants.EVENT_DEL_NODE_ATTR).put(this.sourceIdBuff).put(this.encodeUnsignedVarint(timeId)).put(nodeBuff).put(attrBuff);
        this.doSend(buff);
    }

    @Override
    public void edgeAttributeAdded(String sourceId, long timeId, String edgeId, String attribute, Object value) {
        if (!sourceId.equals(this.sourceId)) {
            this.sourceId = sourceId;
            this.sourceIdBuff = this.encodeString(sourceId);
        }
        ByteBuffer edgeBuff = this.encodeString(edgeId);
        ByteBuffer attrBuff = this.encodeString(attribute);
        int valueType = this.getType(value);
        ByteBuffer valueBuff = this.encodeValue(value, valueType);
        ByteBuffer buff = ByteBuffer.allocate(this.streamBuffer.capacity() + 1 + this.sourceIdBuff.capacity() + this.varintSize(timeId) + edgeBuff.capacity() + attrBuff.capacity() + 1 + valueBuff.capacity());
        this.streamBuffer.rewind();
        this.sourceIdBuff.rewind();
        buff.put(this.streamBuffer).put((byte)NetStreamConstants.EVENT_ADD_EDGE_ATTR).put(this.sourceIdBuff).put(this.encodeUnsignedVarint(timeId)).put(edgeBuff).put(attrBuff).put((byte)valueType).put(valueBuff);
        this.doSend(buff);
    }

    @Override
    public void edgeAttributeChanged(String sourceId, long timeId, String edgeId, String attribute, Object oldValue, Object newValue) {
        if (!sourceId.equals(this.sourceId)) {
            this.sourceId = sourceId;
            this.sourceIdBuff = this.encodeString(sourceId);
        }
        ByteBuffer edgeBuff = this.encodeString(edgeId);
        ByteBuffer attrBuff = this.encodeString(attribute);
        int oldValueType = this.getType(oldValue);
        int newValueType = this.getType(newValue);
        ByteBuffer oldValueBuff = this.encodeValue(oldValue, oldValueType);
        ByteBuffer newValueBuff = this.encodeValue(newValue, newValueType);
        ByteBuffer buff = ByteBuffer.allocate(this.streamBuffer.capacity() + 1 + this.sourceIdBuff.capacity() + this.varintSize(timeId) + edgeBuff.capacity() + attrBuff.capacity() + 1 + oldValueBuff.capacity() + 1 + newValueBuff.capacity());
        this.streamBuffer.rewind();
        this.sourceIdBuff.rewind();
        buff.put(this.streamBuffer).put((byte)NetStreamConstants.EVENT_CHG_EDGE_ATTR).put(this.sourceIdBuff).put(this.encodeUnsignedVarint(timeId)).put(edgeBuff).put(attrBuff).put((byte)oldValueType).put(oldValueBuff).put((byte)newValueType).put(newValueBuff);
        this.doSend(buff);
    }

    @Override
    public void edgeAttributeRemoved(String sourceId, long timeId, String edgeId, String attribute) {
        if (!sourceId.equals(this.sourceId)) {
            this.sourceId = sourceId;
            this.sourceIdBuff = this.encodeString(sourceId);
        }
        ByteBuffer edgeBuff = this.encodeString(edgeId);
        ByteBuffer attrBuff = this.encodeString(attribute);
        ByteBuffer buff = ByteBuffer.allocate(this.streamBuffer.capacity() + 1 + this.sourceIdBuff.capacity() + this.varintSize(timeId) + edgeBuff.capacity() + attrBuff.capacity());
        this.streamBuffer.rewind();
        this.sourceIdBuff.rewind();
        buff.put(this.streamBuffer).put((byte)NetStreamConstants.EVENT_DEL_EDGE_ATTR).put(this.sourceIdBuff).put(this.encodeUnsignedVarint(timeId)).put(edgeBuff).put(attrBuff);
        this.doSend(buff);
    }

    @Override
    public void nodeAdded(String sourceId, long timeId, String nodeId) {
        if (!sourceId.equals(this.sourceId)) {
            this.sourceId = sourceId;
            this.sourceIdBuff = this.encodeString(sourceId);
        }
        ByteBuffer nodeBuff = this.encodeString(nodeId);
        ByteBuffer buff = ByteBuffer.allocate(this.streamBuffer.capacity() + 1 + this.sourceIdBuff.capacity() + this.varintSize(timeId) + nodeBuff.capacity());
        this.streamBuffer.rewind();
        this.sourceIdBuff.rewind();
        buff.put(this.streamBuffer).put((byte)NetStreamConstants.EVENT_ADD_NODE).put(this.sourceIdBuff).put(this.encodeUnsignedVarint(timeId)).put(nodeBuff);
        this.doSend(buff);
    }

    @Override
    public void nodeRemoved(String sourceId, long timeId, String nodeId) {
        if (!sourceId.equals(this.sourceId)) {
            this.sourceId = sourceId;
            this.sourceIdBuff = this.encodeString(sourceId);
        }
        ByteBuffer nodeBuff = this.encodeString(nodeId);
        ByteBuffer buff = ByteBuffer.allocate(this.streamBuffer.capacity() + 1 + this.sourceIdBuff.capacity() + this.varintSize(timeId) + nodeBuff.capacity());
        this.streamBuffer.rewind();
        this.sourceIdBuff.rewind();
        buff.put(this.streamBuffer).put((byte)NetStreamConstants.EVENT_DEL_NODE).put(this.sourceIdBuff).put(this.encodeUnsignedVarint(timeId)).put(nodeBuff);
        this.doSend(buff);
    }

    @Override
    public void edgeAdded(String sourceId, long timeId, String edgeId, String fromNodeId, String toNodeId, boolean directed) {
        if (!sourceId.equals(this.sourceId)) {
            this.sourceId = sourceId;
            this.sourceIdBuff = this.encodeString(sourceId);
        }
        ByteBuffer edgeBuff = this.encodeString(edgeId);
        ByteBuffer fromNodeBuff = this.encodeString(fromNodeId);
        ByteBuffer toNodeBuff = this.encodeString(toNodeId);
        ByteBuffer buff = ByteBuffer.allocate(this.streamBuffer.capacity() + 1 + this.sourceIdBuff.capacity() + this.varintSize(timeId) + edgeBuff.capacity() + fromNodeBuff.capacity() + toNodeBuff.capacity() + 1);
        this.streamBuffer.rewind();
        this.sourceIdBuff.rewind();
        buff.put(this.streamBuffer).put((byte)NetStreamConstants.EVENT_ADD_EDGE).put(this.sourceIdBuff).put(this.encodeUnsignedVarint(timeId)).put(edgeBuff).put(fromNodeBuff).put(toNodeBuff).put((byte)(directed ? 1 : 0));
        this.doSend(buff);
    }

    @Override
    public void edgeRemoved(String sourceId, long timeId, String edgeId) {
        if (!sourceId.equals(this.sourceId)) {
            this.sourceId = sourceId;
            this.sourceIdBuff = this.encodeString(sourceId);
        }
        ByteBuffer edgeBuff = this.encodeString(edgeId);
        ByteBuffer buff = ByteBuffer.allocate(this.streamBuffer.capacity() + 1 + this.sourceIdBuff.capacity() + this.varintSize(timeId) + edgeBuff.capacity());
        this.streamBuffer.rewind();
        this.sourceIdBuff.rewind();
        buff.put(this.streamBuffer).put((byte)NetStreamConstants.EVENT_DEL_EDGE).put(this.sourceIdBuff).put(this.encodeUnsignedVarint(timeId)).put(edgeBuff);
        this.doSend(buff);
    }

    @Override
    public void graphCleared(String sourceId, long timeId) {
        if (!sourceId.equals(this.sourceId)) {
            this.sourceId = sourceId;
            this.sourceIdBuff = this.encodeString(sourceId);
        }
        ByteBuffer buff = ByteBuffer.allocate(this.streamBuffer.capacity() + 1 + this.sourceIdBuff.capacity() + this.varintSize(timeId));
        this.streamBuffer.rewind();
        this.sourceIdBuff.rewind();
        buff.put(this.streamBuffer).put((byte)NetStreamConstants.EVENT_CLEARED).put(this.sourceIdBuff).put(this.encodeUnsignedVarint(timeId));
        this.doSend(buff);
    }

    @Override
    public void stepBegins(String sourceId, long timeId, double step) {
        if (!sourceId.equals(this.sourceId)) {
            this.sourceId = sourceId;
            this.sourceIdBuff = this.encodeString(sourceId);
        }
        ByteBuffer buff = ByteBuffer.allocate(this.streamBuffer.capacity() + 1 + this.sourceIdBuff.capacity() + this.varintSize(timeId) + 8);
        this.streamBuffer.rewind();
        this.sourceIdBuff.rewind();
        buff.put(this.streamBuffer).put((byte)NetStreamConstants.EVENT_STEP).put(this.sourceIdBuff).put(this.encodeUnsignedVarint(timeId)).putDouble(step);
        this.doSend(buff);
    }

    public void close() throws IOException {
        this.socket.close();
    }

    class DefaultPacker
    extends NetStreamPacker {
        ByteBuffer sizeBuffer = ByteBuffer.allocate(4);

        DefaultPacker() {
        }

        @Override
        public ByteBuffer packMessage(ByteBuffer buffer, int startIndex, int endIndex) {
            return buffer;
        }

        @Override
        public ByteBuffer packMessageSize(int capacity) {
            this.sizeBuffer.rewind();
            this.sizeBuffer.putInt(capacity);
            return this.sizeBuffer;
        }
    }
}

