/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.graphicGraph;

import java.util.logging.Logger;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.ui.geom.Point2;
import org.graphstream.ui.geom.Point3;
import org.graphstream.ui.geom.Vector2;
import org.graphstream.ui.geom.Vector3;

public class GraphPosLengthUtils {
    private static final Logger logger = Logger.getLogger(GraphPosLengthUtils.class.getSimpleName());

    public static double[] nodePosition(Graph graph, String id) {
        Object node = graph.getNode(id);
        if (node != null) {
            return GraphPosLengthUtils.nodePosition(node);
        }
        return null;
    }

    public static Point3 nodePointPosition(Graph graph, String id) {
        Object node = graph.getNode(id);
        if (node != null) {
            return GraphPosLengthUtils.nodePointPosition(node);
        }
        return null;
    }

    public static double[] nodePosition(Node node) {
        double[] xyz = new double[3];
        GraphPosLengthUtils.nodePosition(node, xyz);
        return xyz;
    }

    public static Point3 nodePointPosition(Node node) {
        Point3 pos = new Point3();
        GraphPosLengthUtils.nodePosition(node, pos);
        return pos;
    }

    public static void nodePosition(Graph graph, String id, double[] xyz) {
        Object node = graph.getNode(id);
        if (node != null) {
            GraphPosLengthUtils.nodePosition(node, xyz);
        }
        throw new RuntimeException("node '" + id + "' does not exist");
    }

    public static void nodePosition(Graph graph, String id, Point3 pos) {
        Object node = graph.getNode(id);
        if (node != null) {
            GraphPosLengthUtils.nodePosition(node, pos);
        }
        throw new RuntimeException("node '" + id + "' does not exist");
    }

    public static void nodePosition(Node node, double[] xyz) {
        if (xyz.length < 3) {
            return;
        }
        if (node.hasAttribute("xyz") || node.hasAttribute("xy")) {
            Object o = node.getAttribute("xyz");
            if (o == null) {
                o = node.getAttribute("xy");
            }
            if (o != null) {
                GraphPosLengthUtils.positionFromObject(o, xyz);
            }
        } else if (node.hasAttribute("x")) {
            xyz[0] = node.getNumber("x");
            if (node.hasAttribute("y")) {
                xyz[1] = node.getNumber("y");
            }
            if (node.hasAttribute("z")) {
                xyz[2] = node.getNumber("z");
            }
        }
    }

    public static void nodePosition(Node node, Point3 pos) {
        if (node.hasAttribute("xyz") || node.hasAttribute("xy")) {
            Object o = node.getAttribute("xyz");
            if (o == null) {
                o = node.getAttribute("xy");
            }
            if (o != null) {
                GraphPosLengthUtils.positionFromObject(o, pos);
            }
        } else if (node.hasAttribute("x")) {
            pos.x = node.getNumber("x");
            if (node.hasAttribute("y")) {
                pos.y = node.getNumber("y");
            }
            if (node.hasAttribute("z")) {
                pos.z = node.getNumber("z");
            }
        }
    }

    public static void positionFromObject(Object o, double[] xyz) {
        if (o instanceof Object[]) {
            Object[] oo = (Object[])o;
            if (oo.length > 0 && oo[0] instanceof Number) {
                xyz[0] = ((Number)oo[0]).doubleValue();
                if (oo.length > 1) {
                    xyz[1] = ((Number)oo[1]).doubleValue();
                }
                if (oo.length > 2) {
                    xyz[2] = ((Number)oo[2]).doubleValue();
                }
            }
        } else if (o instanceof Double[]) {
            Double[] oo = (Double[])o;
            if (oo.length > 0) {
                xyz[0] = oo[0];
            }
            if (oo.length > 1) {
                xyz[1] = oo[1];
            }
            if (oo.length > 2) {
                xyz[2] = oo[2];
            }
        } else if (o instanceof Float[]) {
            Float[] oo = (Float[])o;
            if (oo.length > 0) {
                xyz[0] = oo[0].floatValue();
            }
            if (oo.length > 1) {
                xyz[1] = oo[1].floatValue();
            }
            if (oo.length > 2) {
                xyz[2] = oo[2].floatValue();
            }
        } else if (o instanceof Integer[]) {
            Integer[] oo = (Integer[])o;
            if (oo.length > 0) {
                xyz[0] = oo[0].intValue();
            }
            if (oo.length > 1) {
                xyz[1] = oo[1].intValue();
            }
            if (oo.length > 2) {
                xyz[2] = oo[2].intValue();
            }
        } else if (o instanceof double[]) {
            double[] oo = (double[])o;
            if (oo.length > 0) {
                xyz[0] = oo[0];
            }
            if (oo.length > 1) {
                xyz[1] = oo[1];
            }
            if (oo.length > 2) {
                xyz[2] = oo[2];
            }
        } else if (o instanceof float[]) {
            float[] oo = (float[])o;
            if (oo.length > 0) {
                xyz[0] = oo[0];
            }
            if (oo.length > 1) {
                xyz[1] = oo[1];
            }
            if (oo.length > 2) {
                xyz[2] = oo[2];
            }
        } else if (o instanceof int[]) {
            int[] oo = (int[])o;
            if (oo.length > 0) {
                xyz[0] = oo[0];
            }
            if (oo.length > 1) {
                xyz[1] = oo[1];
            }
            if (oo.length > 2) {
                xyz[2] = oo[2];
            }
        } else if (o instanceof Number[]) {
            Number[] oo = (Number[])o;
            if (oo.length > 0) {
                xyz[0] = oo[0].doubleValue();
            }
            if (oo.length > 1) {
                xyz[1] = oo[1].doubleValue();
            }
            if (oo.length > 2) {
                xyz[2] = oo[2].doubleValue();
            }
        } else if (o instanceof Point3) {
            Point3 oo = (Point3)o;
            xyz[0] = oo.x;
            xyz[1] = oo.y;
            xyz[2] = oo.z;
        } else if (o instanceof Vector3) {
            Vector3 oo = (Vector3)o;
            xyz[0] = oo.data[0];
            xyz[1] = oo.data[1];
            xyz[2] = oo.data[2];
        } else if (o instanceof Point2) {
            Point2 oo = (Point2)o;
            xyz[0] = oo.x;
            xyz[1] = oo.y;
            xyz[2] = 0.0;
        } else if (o instanceof Vector2) {
            Vector2 oo = (Vector2)o;
            xyz[0] = oo.data[0];
            xyz[1] = oo.data[1];
            xyz[2] = 0.0;
        } else {
            logger.warning(String.format("Do not know how to handle xyz attribute %s.", o.getClass().getName()));
        }
    }

    public static void positionFromObject(Object o, Point3 pos) {
        if (o instanceof Object[]) {
            Object[] oo = (Object[])o;
            if (oo.length > 0 && oo[0] instanceof Number) {
                pos.x = ((Number)oo[0]).doubleValue();
                if (oo.length > 1) {
                    pos.y = ((Number)oo[1]).doubleValue();
                }
                if (oo.length > 2) {
                    pos.z = ((Number)oo[2]).doubleValue();
                }
            }
        } else if (o instanceof Double[]) {
            Double[] oo = (Double[])o;
            if (oo.length > 0) {
                pos.x = oo[0];
            }
            if (oo.length > 1) {
                pos.y = oo[1];
            }
            if (oo.length > 2) {
                pos.z = oo[2];
            }
        } else if (o instanceof Float[]) {
            Float[] oo = (Float[])o;
            if (oo.length > 0) {
                pos.x = oo[0].floatValue();
            }
            if (oo.length > 1) {
                pos.y = oo[1].floatValue();
            }
            if (oo.length > 2) {
                pos.z = oo[2].floatValue();
            }
        } else if (o instanceof Integer[]) {
            Integer[] oo = (Integer[])o;
            if (oo.length > 0) {
                pos.x = oo[0].intValue();
            }
            if (oo.length > 1) {
                pos.y = oo[1].intValue();
            }
            if (oo.length > 2) {
                pos.z = oo[2].intValue();
            }
        } else if (o instanceof double[]) {
            double[] oo = (double[])o;
            if (oo.length > 0) {
                pos.x = oo[0];
            }
            if (oo.length > 1) {
                pos.y = oo[1];
            }
            if (oo.length > 2) {
                pos.z = oo[2];
            }
        } else if (o instanceof float[]) {
            float[] oo = (float[])o;
            if (oo.length > 0) {
                pos.x = oo[0];
            }
            if (oo.length > 1) {
                pos.y = oo[1];
            }
            if (oo.length > 2) {
                pos.z = oo[2];
            }
        } else if (o instanceof int[]) {
            int[] oo = (int[])o;
            if (oo.length > 0) {
                pos.x = oo[0];
            }
            if (oo.length > 1) {
                pos.y = oo[1];
            }
            if (oo.length > 2) {
                pos.z = oo[2];
            }
        } else if (o instanceof Number[]) {
            Number[] oo = (Number[])o;
            if (oo.length > 0) {
                pos.x = oo[0].doubleValue();
            }
            if (oo.length > 1) {
                pos.y = oo[1].doubleValue();
            }
            if (oo.length > 2) {
                pos.z = oo[2].doubleValue();
            }
        } else if (o instanceof Point3) {
            Point3 oo = (Point3)o;
            pos.x = oo.x;
            pos.y = oo.y;
            pos.z = oo.z;
        } else if (o instanceof Vector3) {
            Vector3 oo = (Vector3)o;
            pos.x = oo.data[0];
            pos.y = oo.data[1];
            pos.z = oo.data[2];
        } else if (o instanceof Point2) {
            Point2 oo = (Point2)o;
            pos.x = oo.x;
            pos.y = oo.y;
            pos.z = 0.0;
        } else if (o instanceof Vector2) {
            Vector2 oo = (Vector2)o;
            pos.x = oo.data[0];
            pos.y = oo.data[1];
            pos.z = 0.0;
        } else {
            logger.warning(String.format("Do not know how to handle xyz attribute %s%n", o.getClass().getName()));
        }
    }

    public static double edgeLength(Graph graph, String id) {
        Object edge = graph.getEdge(id);
        if (edge != null) {
            return GraphPosLengthUtils.edgeLength(edge);
        }
        throw new RuntimeException("edge '" + id + "' cannot be found");
    }

    public static double edgeLength(Edge edge) {
        double[] xyz0 = GraphPosLengthUtils.nodePosition(edge.getNode0());
        double[] xyz1 = GraphPosLengthUtils.nodePosition(edge.getNode1());
        if (xyz0 == null || xyz1 == null) {
            return -1.0;
        }
        xyz0[0] = xyz1[0] - xyz0[0];
        xyz0[1] = xyz1[1] - xyz0[1];
        xyz0[2] = xyz1[2] - xyz0[2];
        return Math.sqrt(xyz0[0] * xyz0[0] + xyz0[1] * xyz0[1] + xyz0[2] * xyz0[2]);
    }
}

