/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.layout.springbox;

public class Energies {
    protected double energy;
    protected double lastEnergy;
    protected int energiesBuffer = 256;
    protected double[] energies = new double[this.energiesBuffer];
    protected int energiesPos = 0;
    protected double energySum = 0.0;

    public double getEnergy() {
        return this.lastEnergy;
    }

    public int getBufferSize() {
        return this.energiesBuffer;
    }

    public double getStabilization() {
        double eprev3;
        double eprev2;
        int range = 200;
        double eprev1 = this.getPreviousEnergyValue(range);
        double eprev = (eprev1 + (eprev2 = this.getPreviousEnergyValue(range - 10)) + (eprev3 = this.getPreviousEnergyValue(range - 20))) / 3.0;
        double diff = Math.abs(this.lastEnergy - eprev);
        diff = diff < 1.0 ? 1.0 : diff;
        return 1.0 / diff;
    }

    public double getAverageEnergy() {
        return this.energySum / (double)this.energies.length;
    }

    public double getPreviousEnergyValue(int stepsBack) {
        if (stepsBack >= this.energies.length) {
            stepsBack = this.energies.length - 1;
        }
        int pos = (this.energies.length + (this.energiesPos - stepsBack)) % this.energies.length;
        return this.energies[pos];
    }

    public void accumulateEnergy(double value) {
        this.energy += value;
    }

    public void storeEnergy() {
        this.energiesPos = (this.energiesPos + 1) % this.energies.length;
        this.energySum -= this.energies[this.energiesPos];
        this.energies[this.energiesPos] = this.energy;
        this.energySum += this.energy;
        this.lastEnergy = this.energy;
        this.energy = 0.0;
    }

    protected void clearEnergies() {
        for (int i = 0; i < this.energies.length; ++i) {
            this.energies[i] = Math.random() * 2000.0 - 1000.0;
        }
    }
}

