/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.engine;

import guru.nidi.graphviz.engine.AbstractGraphvizEngine;
import guru.nidi.graphviz.engine.BuiltInRasterizer;
import guru.nidi.graphviz.engine.Engine;
import guru.nidi.graphviz.engine.EngineResult;
import guru.nidi.graphviz.engine.Format;
import guru.nidi.graphviz.engine.GraphvizException;
import guru.nidi.graphviz.engine.Options;
import guru.nidi.graphviz.engine.Rasterizer;
import guru.nidi.graphviz.service.CommandBuilder;
import guru.nidi.graphviz.service.CommandLineExecutor;
import guru.nidi.graphviz.service.CommandRunner;
import guru.nidi.graphviz.service.SystemUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphvizCmdLineEngine
extends AbstractGraphvizEngine {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractGraphvizEngine.class);
    private final String envPath;
    private final CommandRunner cmdRunner;
    private String outputFilePath;
    private String outputFileName;

    public GraphvizCmdLineEngine() {
        this(Optional.ofNullable(System.getenv("PATH")).orElse(""), new CommandLineExecutor());
    }

    public GraphvizCmdLineEngine(String envPath, CommandLineExecutor executor) {
        super(true);
        this.envPath = envPath;
        this.cmdRunner = new CommandBuilder().withShellWrapper(true).withCommandExecutor(executor).build();
    }

    @Override
    protected void doInit() throws GraphvizException {
        this.getEngineExecutable(Engine.DOT);
    }

    @Override
    public EngineResult execute(String src, Options options, Rasterizer rasterizer) {
        try {
            Path path = Files.createTempDirectory(this.getOrCreateTempDirectory().toPath(), "DotEngine", new FileAttribute[0]);
            File dotFile = this.getDotFile(path);
            try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(dotFile), StandardCharsets.UTF_8));){
                bw.write(this.preprocessCode(src, options));
            }
            return this.doExecute(path, dotFile, options, rasterizer);
        }
        catch (IOException | InterruptedException e) {
            throw new GraphvizException(e.getMessage(), e);
        }
    }

    private EngineResult doExecute(Path path, File dotFile, Options options, Rasterizer rasterizer) throws IOException, InterruptedException {
        String engine = this.getEngineExecutable(options.engine);
        String format = this.getFormatName(options.format, rasterizer);
        String command = engine + (options.yInvert != null && options.yInvert != false ? " -y" : "") + " -T" + format + " " + dotFile.getAbsolutePath() + " -ooutfile." + format;
        this.cmdRunner.exec(command, path.toFile(), new String[0]);
        Path outFile = path.resolve("outfile." + format);
        if (rasterizer instanceof BuiltInRasterizer) {
            return EngineResult.fromFile(outFile.toFile());
        }
        byte[] data = Files.readAllBytes(outFile);
        return EngineResult.fromString(new String(data, StandardCharsets.UTF_8));
    }

    protected String preprocessCode(String src, Options options) {
        String imgReplaced = this.replacePaths(src, IMG_SRC, path -> this.replacePath((String)path, options.basedir));
        return this.replacePaths(imgReplaced, IMAGE_ATTR, path -> this.replacePath((String)path, options.basedir));
    }

    private String getEngineExecutable(Engine engine) {
        String exe = SystemUtils.executableName(engine == null ? "dot" : engine.toString().toLowerCase(Locale.ENGLISH));
        if (!CommandRunner.isExecutableFound(exe, this.envPath)) {
            GraphvizException e = new GraphvizException(exe + " command not found");
            e.setStackTrace(new StackTraceElement[0]);
            throw e;
        }
        return exe;
    }

    private String getFormatName(Format format, Rasterizer rasterizer) {
        if (rasterizer instanceof BuiltInRasterizer) {
            BuiltInRasterizer natRast = (BuiltInRasterizer)rasterizer;
            String f = natRast.format;
            if (natRast.renderer != null) {
                f = f + ":" + natRast.renderer;
            }
            if (natRast.formatter != null) {
                f = f + ":" + natRast.formatter;
            }
            return f;
        }
        return format == null ? "svg" : format.vizName;
    }

    private File getOrCreateTempDirectory() {
        File tempDir = new File(System.getProperty("java.io.tmpdir") + File.separator + "GraphvizJava");
        if (!tempDir.exists() && tempDir.mkdir()) {
            LOG.debug("Created GraphvizJava temporary directory");
        }
        return tempDir;
    }

    private File getDotFile(Path path) {
        String dotFileName = this.outputFileName == null ? "dotfile.dot" : this.outputFileName + ".dot";
        String baseDir = this.outputFilePath == null ? path.toString() : this.outputFilePath;
        return new File(baseDir, dotFileName);
    }

    public void setDotOutputFile(String path, String name) {
        this.outputFilePath = path;
        this.outputFileName = name;
    }
}

