/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.engine;

import guru.nidi.graphviz.engine.AbstractGraphvizEngine;
import guru.nidi.graphviz.engine.Communicator;
import guru.nidi.graphviz.engine.EngineResult;
import guru.nidi.graphviz.engine.GraphvizEngine;
import guru.nidi.graphviz.engine.GraphvizException;
import guru.nidi.graphviz.engine.GraphvizServer;
import guru.nidi.graphviz.engine.Options;
import guru.nidi.graphviz.engine.Rasterizer;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GraphvizServerEngine
extends AbstractGraphvizEngine {
    private final List<GraphvizEngine> engines = new ArrayList<GraphvizEngine>();

    public GraphvizServerEngine() {
        super(false);
    }

    public GraphvizServerEngine useEngine(GraphvizEngine first, GraphvizEngine ... rest) {
        this.engines.clear();
        this.engines.add(first);
        this.engines.addAll(Arrays.asList(rest));
        return this;
    }

    @Override
    public EngineResult execute(String src, Options options, Rasterizer rasterizer) {
        try {
            return EngineResult.fromString(this.createSvg(src, options));
        }
        catch (IOException e) {
            throw new GraphvizException("Problem in communication with server", e);
        }
    }

    @Override
    protected void doInit() throws Exception {
        if (!this.canConnect()) {
            GraphvizServer.start(this.engines);
            for (int i = 0; i < 100 && !this.canConnect(); ++i) {
                try {
                    Thread.sleep(50L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (!this.canConnect()) {
                throw new IOException("Could not connect to server");
            }
        }
    }

    public boolean canConnect() {
        boolean bl;
        Socket socket = new Socket("localhost", 10234);
        try {
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        socket.close();
        return bl;
    }

    private String createSvg(String src, Options options) throws IOException {
        return GraphvizServerEngine.communicating(com -> {
            com.writeContent(options.toJson(true) + "@@@" + src);
            String status = com.readStatus();
            int len = com.readLen();
            String content = com.readContent(len);
            if (!"ok".equals(status)) {
                throw new GraphvizException(content);
            }
            return content;
        });
    }

    public static void stopServer() {
        try {
            GraphvizServerEngine.communicating(com -> {
                com.writeLen(-1);
                return "";
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static <T> T communicating(ComFunc<T> action) throws IOException {
        try (Socket socket = new Socket("localhost", 10234);){
            T t;
            try (Communicator com = new Communicator(socket, 5000);){
                t = action.apply(com);
            }
            return t;
        }
    }

    private static interface ComFunc<T> {
        public T apply(Communicator var1) throws IOException;
    }
}

