/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.service;

import guru.nidi.graphviz.service.CommandLineExecutor;
import guru.nidi.graphviz.service.CommandRunner;
import guru.nidi.graphviz.service.SystemUtils;

public class CommandBuilder {
    private boolean shellWrapper;
    private CommandLineExecutor cmdExec;

    public CommandBuilder withShellWrapper(boolean shellWrapper) {
        this.shellWrapper = shellWrapper;
        return this;
    }

    public CommandBuilder withCommandExecutor(CommandLineExecutor cmdExec) {
        this.cmdExec = cmdExec;
        return this;
    }

    public CommandRunner build() {
        return new CommandRunner(SystemUtils.getShellWrapperOrDefault(this.shellWrapper), CommandBuilder.getCmdExecutorOrDefault(this.cmdExec));
    }

    private static CommandLineExecutor getCmdExecutorOrDefault(CommandLineExecutor cmdExec) {
        return cmdExec == null ? new CommandLineExecutor() : cmdExec;
    }
}

