/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.cml;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import org.contextmapper.dsl.cml.CMLImportResolver;
import org.contextmapper.dsl.cml.CMLResourceContainer;
import org.contextmapper.dsl.contextMappingDSL.Aggregate;
import org.contextmapper.dsl.contextMappingDSL.BoundedContext;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingModel;
import org.contextmapper.dsl.contextMappingDSL.DomainPart;
import org.contextmapper.dsl.contextMappingDSL.Feature;
import org.contextmapper.dsl.contextMappingDSL.SculptorModule;
import org.contextmapper.dsl.contextMappingDSL.Subdomain;
import org.contextmapper.dsl.contextMappingDSL.UserRequirement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

public class CMLModelObjectsResolvingHelper {
    private Set<ContextMappingModel> resolveImportedModels(ContextMappingModel rootModel) {
        Set<CMLResourceContainer> importedResources = new CMLImportResolver().resolveImportedResources(new CMLResourceContainer(rootModel.eResource()));
        return importedResources.stream().map(r -> r.getContextMappingModel()).collect(Collectors.toSet());
    }

    public <T extends EObject> Set<T> resolveAllObjectsOfType(ContextMappingModel rootModel, Class<T> type) {
        HashSet resultSet = Sets.newHashSet();
        resultSet.addAll(Sets.newHashSet((Iterator)IteratorExtensions.filter((Iterator)EcoreUtil2.eAll((EObject)rootModel), type)));
        for (ContextMappingModel model : this.resolveImportedModels(rootModel)) {
            resultSet.addAll(Sets.newHashSet((Iterator)IteratorExtensions.filter((Iterator)EcoreUtil2.eAll((EObject)model), type)));
        }
        return resultSet;
    }

    public BoundedContext resolveBoundedContext(Aggregate aggregate) {
        if (aggregate.eContainer() != null && aggregate.eContainer() instanceof SculptorModule) {
            return this.resolveBoundedContext((SculptorModule)aggregate.eContainer());
        }
        return (BoundedContext)aggregate.eContainer();
    }

    public BoundedContext resolveBoundedContext(SculptorModule module) {
        return (BoundedContext)module.eContainer();
    }

    public Set<UserRequirement> resolveUserRequirements(BoundedContext boundedContext) {
        HashSet requirements = Sets.newHashSet();
        for (DomainPart domainPart : boundedContext.getImplementedDomainParts()) {
            if (!(domainPart instanceof Subdomain)) continue;
            Subdomain subdomain = (Subdomain)domainPart;
            requirements.addAll(subdomain.getSupportedFeatures());
        }
        return requirements;
    }

    public Set<Feature> resolveFeatures(BoundedContext boundedContext) {
        HashSet features = Sets.newHashSet();
        this.resolveUserRequirements(boundedContext).forEach(ur -> features.addAll(ur.getFeatures()));
        return features;
    }
}

