/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.cml;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.List;
import org.contextmapper.dsl.cml.exception.ResourceIsNoCMLModelException;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingModel;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

public class CMLResourceContainer {
    private final Resource resource;

    public CMLResourceContainer(Resource resource) {
        if (resource.getContents().isEmpty()) {
            this.throwResourceIsNoCMLModelException(resource);
        }
        if (!(resource.getContents().get(0) instanceof ContextMappingModel)) {
            this.throwResourceIsNoCMLModelException(resource);
        }
        this.resource = resource;
        this.resource.setTrackingModification(true);
    }

    public Resource getResource() {
        return this.resource;
    }

    public ContextMappingModel getContextMappingModel() {
        List contextMappingModels = IteratorExtensions.toList((Iterator)Iterators.filter((Iterator)this.resource.getAllContents(), ContextMappingModel.class));
        return (ContextMappingModel)contextMappingModels.get(0);
    }

    private void throwResourceIsNoCMLModelException(Resource resource) {
        if (resource.getURI() != null) {
            throw new ResourceIsNoCMLModelException(resource.getURI());
        }
        throw new ResourceIsNoCMLModelException();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CMLResourceContainer)) {
            return false;
        }
        CMLResourceContainer otherResource = (CMLResourceContainer)obj;
        return this.resource.getURI().equals(otherResource.resource.getURI());
    }

    public int hashCode() {
        return this.resource.getURI().hashCode();
    }
}

