/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.contextMappingDSL;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum LikelihoodForChange implements Enumerator
{
    NORMAL(0, "NORMAL", "NORMAL"),
    RARELY(1, "RARELY", "RARELY"),
    OFTEN(2, "OFTEN", "OFTEN");

    public static final int NORMAL_VALUE = 0;
    public static final int RARELY_VALUE = 1;
    public static final int OFTEN_VALUE = 2;
    private static final LikelihoodForChange[] VALUES_ARRAY;
    public static final List<LikelihoodForChange> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static LikelihoodForChange get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            LikelihoodForChange result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static LikelihoodForChange getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            LikelihoodForChange result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static LikelihoodForChange get(int value) {
        switch (value) {
            case 0: {
                return NORMAL;
            }
            case 1: {
                return RARELY;
            }
            case 2: {
                return OFTEN;
            }
        }
        return null;
    }

    private LikelihoodForChange(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new LikelihoodForChange[]{NORMAL, RARELY, OFTEN};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

