/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.generator;

import guru.nidi.graphviz.engine.Format;
import guru.nidi.graphviz.service.CommandRunner;
import guru.nidi.graphviz.service.SystemUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.contextmapper.dsl.contextMappingDSL.ContextMap;
import org.contextmapper.dsl.generator.AbstractContextMapGenerator;
import org.contextmapper.dsl.generator.contextmap.ContextMapFormat;
import org.contextmapper.dsl.generator.contextmap.ContextMapModelConverter;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.generator.IFileSystemAccess2;

public class ContextMapGenerator
extends AbstractContextMapGenerator {
    private Set<ContextMapFormat> formats = new HashSet<ContextMapFormat>();
    private int labelSpacingFactor = 5;
    private int width = -1;
    private int height = -1;
    private boolean useWidth = true;
    private boolean printAdditionalLabels = false;

    public ContextMapGenerator() {
        this.formats.add(ContextMapFormat.PNG);
        this.formats.add(ContextMapFormat.SVG);
        this.formats.add(ContextMapFormat.DOT);
    }

    @Override
    protected void generateFromContextMap(ContextMap cmlContextMap, IFileSystemAccess2 fsa, URI inputFileURI) {
        String fileName = inputFileURI.trimFileExtension().lastSegment();
        org.contextmapper.contextmap.generator.model.ContextMap contextMap = new ContextMapModelConverter().convert(cmlContextMap, this.printAdditionalLabels);
        org.contextmapper.contextmap.generator.ContextMapGenerator generator = this.createContextMapGenerator();
        generator.setLabelSpacingFactor(this.labelSpacingFactor);
        if (this.width > 0 && this.useWidth) {
            generator.setWidth(this.width);
        } else if (this.height > 0) {
            generator.setHeight(this.height);
        }
        for (ContextMapFormat format : this.formats) {
            try (ByteArrayOutputStream outputstream = new ByteArrayOutputStream();){
                generator.generateContextMapGraphic(contextMap, this.getGraphvizLibFormat(format), (OutputStream)outputstream);
                try (ByteArrayInputStream inputstream = new ByteArrayInputStream(outputstream.toByteArray());){
                    fsa.generateFile(fileName + "_ContextMap." + format.getFileExtension(), (InputStream)inputstream);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("An error occured while generating the Context Map!", e);
            }
        }
    }

    public void setContextMapFormats(ContextMapFormat ... formats) {
        this.formats.clear();
        this.formats.addAll(Arrays.asList(formats));
    }

    public void setLabelSpacingFactor(int labelSpacingFactor) {
        this.labelSpacingFactor = labelSpacingFactor;
    }

    public void setWidth(int width) {
        if (width < 1) {
            throw new IllegalArgumentException("Please specify a width that is bigger that 0!");
        }
        this.useWidth = true;
        this.width = width;
    }

    public void setHeight(int height) {
        if (height < 1) {
            throw new IllegalArgumentException("Please specify a height that is bigger that 0!");
        }
        this.useWidth = false;
        this.height = height;
    }

    public void printAdditionalLabels(boolean printAdditionalLabels) {
        this.printAdditionalLabels = printAdditionalLabels;
    }

    public boolean printAdditionalLabels() {
        return this.printAdditionalLabels;
    }

    private Format getGraphvizLibFormat(ContextMapFormat format) {
        if (format == ContextMapFormat.SVG) {
            return Format.SVG;
        }
        if (format == ContextMapFormat.DOT) {
            return Format.DOT;
        }
        return Format.PNG;
    }

    protected org.contextmapper.contextmap.generator.ContextMapGenerator createContextMapGenerator() {
        return new org.contextmapper.contextmap.generator.ContextMapGenerator();
    }

    public boolean isGraphvizInstalled() {
        String envPath;
        String execName = SystemUtils.executableName((String)"dot");
        return CommandRunner.isExecutableFound((String)execName, (String)(envPath = Optional.ofNullable(System.getenv("PATH")).orElse("")));
    }
}

