/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.generator;

import java.util.Iterator;
import java.util.Optional;
import org.contextmapper.dsl.contextMappingDSL.BoundedContext;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingModel;
import org.contextmapper.dsl.contextMappingDSL.Domain;
import org.contextmapper.dsl.contextMappingDSL.Subdomain;
import org.contextmapper.dsl.generator.AbstractContextMappingModelGenerator;
import org.contextmapper.dsl.generator.exception.GeneratorInputException;
import org.contextmapper.dsl.generator.plantuml.PlantUMLBoundedContextClassDiagramCreator;
import org.contextmapper.dsl.generator.plantuml.PlantUMLComponentDiagramCreator;
import org.contextmapper.dsl.generator.plantuml.PlantUMLSubdomainClassDiagramCreator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.generator.IFileSystemAccess2;

public class PlantUMLGenerator
extends AbstractContextMappingModelGenerator {
    private static final String PLANT_UML_FILE_EXT = "puml";

    @Override
    protected void generateFromContextMappingModel(ContextMappingModel model, IFileSystemAccess2 fsa, URI inputFileURI) {
        this.checkPreconditions();
        String fileName = inputFileURI.trimFileExtension().lastSegment();
        if (model.getMap() != null) {
            fsa.generateFile(fileName + "_ContextMap." + PLANT_UML_FILE_EXT, (CharSequence)new PlantUMLComponentDiagramCreator().createDiagram(model.getMap()));
        }
        for (BoundedContext boundedContext : model.getBoundedContexts()) {
            fsa.generateFile(fileName + "_BC_" + boundedContext.getName() + "." + PLANT_UML_FILE_EXT, (CharSequence)new PlantUMLBoundedContextClassDiagramCreator().createDiagram(boundedContext));
        }
        for (Domain domain : model.getDomains()) {
            domain.getSubdomains().stream().filter(subdomain -> !subdomain.getEntities().isEmpty()).forEach(subdomain -> fsa.generateFile(fileName + "_SD_" + subdomain.getName() + "." + PLANT_UML_FILE_EXT, (CharSequence)new PlantUMLSubdomainClassDiagramCreator(domain.getName()).createDiagram(subdomain)));
        }
    }

    private void checkPreconditions() {
        if (this.contextMappingModel.getMap() == null && this.contextMappingModel.getBoundedContexts().isEmpty() && !this.modelHasSubdomainWithEntities()) {
            throw new GeneratorInputException("Your model does not contain a Context Map, a Bounded Context, or a Subdomain. Therefore we have nothing to generate. Create at least one of the mentioned Objects.");
        }
    }

    private boolean modelHasSubdomainWithEntities() {
        Iterator iterator = this.contextMappingModel.getDomains().iterator();
        if (iterator.hasNext()) {
            Domain domain = (Domain)iterator.next();
            Optional<Subdomain> optSubdomain = domain.getSubdomains().stream().filter(subdomain -> !subdomain.getEntities().isEmpty()).findAny();
            return optSubdomain.isPresent();
        }
        return false;
    }
}

