/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.generator.contextmap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.contextmapper.contextmap.generator.model.BoundedContext;
import org.contextmapper.contextmap.generator.model.ContextMap;
import org.contextmapper.contextmap.generator.model.DownstreamPatterns;
import org.contextmapper.contextmap.generator.model.Relationship;
import org.contextmapper.contextmap.generator.model.UpstreamPatterns;
import org.contextmapper.dsl.contextMappingDSL.CustomerSupplierRelationship;
import org.contextmapper.dsl.contextMappingDSL.DownstreamRole;
import org.contextmapper.dsl.contextMappingDSL.Partnership;
import org.contextmapper.dsl.contextMappingDSL.SharedKernel;
import org.contextmapper.dsl.contextMappingDSL.UpstreamDownstreamRelationship;
import org.contextmapper.dsl.contextMappingDSL.UpstreamRole;

public class ContextMapModelConverter {
    private Map<String, BoundedContext> bcMap = new HashMap<String, BoundedContext>();
    private boolean useNameAndImplementationTechnologyLabels = true;

    public ContextMap convert(org.contextmapper.dsl.contextMappingDSL.ContextMap cmlContextMap) {
        ContextMap contextMap = new ContextMap();
        for (org.contextmapper.dsl.contextMappingDSL.BoundedContext cmlBC : cmlContextMap.getBoundedContexts()) {
            contextMap.addBoundedContext(this.convert(cmlBC));
        }
        for (org.contextmapper.dsl.contextMappingDSL.Relationship cmlRelationship : cmlContextMap.getRelationships()) {
            contextMap.addRelationship(this.convert(cmlRelationship));
        }
        return contextMap;
    }

    public ContextMap convert(org.contextmapper.dsl.contextMappingDSL.ContextMap cmlContextMap, boolean useNameAndImplementationTechnologyLabels) {
        this.useNameAndImplementationTechnologyLabels = useNameAndImplementationTechnologyLabels;
        return this.convert(cmlContextMap);
    }

    private BoundedContext convert(org.contextmapper.dsl.contextMappingDSL.BoundedContext cmlBoundedContext) {
        BoundedContext boundedContext = new BoundedContext(cmlBoundedContext.getName());
        this.bcMap.put(cmlBoundedContext.getName(), boundedContext);
        return boundedContext;
    }

    private Relationship convert(org.contextmapper.dsl.contextMappingDSL.Relationship cmlRelationship) {
        org.contextmapper.contextmap.generator.model.Partnership relationship = null;
        if (cmlRelationship instanceof Partnership) {
            Partnership cmlPartnership = (Partnership)cmlRelationship;
            relationship = new org.contextmapper.contextmap.generator.model.Partnership(this.bcMap.get(cmlPartnership.getParticipant1().getName()), this.bcMap.get(cmlPartnership.getParticipant2().getName()));
        } else if (cmlRelationship instanceof SharedKernel) {
            SharedKernel cmlSharedKernel = (SharedKernel)cmlRelationship;
            relationship = new org.contextmapper.contextmap.generator.model.SharedKernel(this.bcMap.get(cmlSharedKernel.getParticipant1().getName()), this.bcMap.get(cmlSharedKernel.getParticipant2().getName()));
        } else if (cmlRelationship instanceof CustomerSupplierRelationship) {
            CustomerSupplierRelationship cmlCustomerSupplier = (CustomerSupplierRelationship)cmlRelationship;
            relationship = new org.contextmapper.contextmap.generator.model.UpstreamDownstreamRelationship(this.bcMap.get(cmlCustomerSupplier.getUpstream().getName()), this.bcMap.get(cmlCustomerSupplier.getDownstream().getName()));
            ((org.contextmapper.contextmap.generator.model.UpstreamDownstreamRelationship)relationship).setCustomerSupplier(true);
            ((org.contextmapper.contextmap.generator.model.UpstreamDownstreamRelationship)relationship).setUpstreamPatterns(this.convertUpstreamRoles((List<UpstreamRole>)cmlCustomerSupplier.getUpstreamRoles()));
            ((org.contextmapper.contextmap.generator.model.UpstreamDownstreamRelationship)relationship).setDownstreamPatterns(this.convertDownstreamRoles((List<DownstreamRole>)cmlCustomerSupplier.getDownstreamRoles()));
        } else {
            UpstreamDownstreamRelationship cmlUpstreamDownstream = (UpstreamDownstreamRelationship)cmlRelationship;
            relationship = new org.contextmapper.contextmap.generator.model.UpstreamDownstreamRelationship(this.bcMap.get(cmlUpstreamDownstream.getUpstream().getName()), this.bcMap.get(cmlUpstreamDownstream.getDownstream().getName()));
            ((org.contextmapper.contextmap.generator.model.UpstreamDownstreamRelationship)relationship).setUpstreamPatterns(this.convertUpstreamRoles((List<UpstreamRole>)cmlUpstreamDownstream.getUpstreamRoles()));
            ((org.contextmapper.contextmap.generator.model.UpstreamDownstreamRelationship)relationship).setDownstreamPatterns(this.convertDownstreamRoles((List<DownstreamRole>)cmlUpstreamDownstream.getDownstreamRoles()));
        }
        if (this.useNameAndImplementationTechnologyLabels && cmlRelationship.getName() != null) {
            relationship.setName(cmlRelationship.getName());
        }
        if (this.useNameAndImplementationTechnologyLabels && cmlRelationship.getImplementationTechnology() != null) {
            relationship.setImplementationTechnology(cmlRelationship.getImplementationTechnology());
        }
        return relationship;
    }

    private UpstreamPatterns[] convertUpstreamRoles(List<UpstreamRole> upstreamRoles) {
        ArrayList<UpstreamPatterns> upstreamPatterns = new ArrayList<UpstreamPatterns>();
        if (upstreamRoles.contains((Object)UpstreamRole.OPEN_HOST_SERVICE)) {
            upstreamPatterns.add(UpstreamPatterns.OPEN_HOST_SERVICE);
        }
        if (upstreamRoles.contains((Object)UpstreamRole.PUBLISHED_LANGUAGE)) {
            upstreamPatterns.add(UpstreamPatterns.PUBLISHED_LANGUAGE);
        }
        return upstreamPatterns.toArray(new UpstreamPatterns[upstreamPatterns.size()]);
    }

    private DownstreamPatterns[] convertDownstreamRoles(List<DownstreamRole> downstreamRoles) {
        ArrayList<DownstreamPatterns> downstreamPatterns = new ArrayList<DownstreamPatterns>();
        if (downstreamRoles.contains((Object)DownstreamRole.ANTICORRUPTION_LAYER)) {
            downstreamPatterns.add(DownstreamPatterns.ANTICORRUPTION_LAYER);
        }
        if (downstreamRoles.contains((Object)DownstreamRole.CONFORMIST)) {
            downstreamPatterns.add(DownstreamPatterns.CONFORMIST);
        }
        return downstreamPatterns.toArray(new DownstreamPatterns[downstreamPatterns.size()]);
    }
}

