/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.generator.mdsl.generatorcontext;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.contextmapper.dsl.contextMappingDSL.Aggregate;
import org.contextmapper.dsl.contextMappingDSL.BoundedContext;
import org.contextmapper.dsl.contextMappingDSL.DownstreamRole;

public class DownstreamContext {
    private BoundedContext downstreamContext;
    private List<Aggregate> consumedAggregates = Lists.newArrayList();
    private Set<DownstreamRole> downstreamRoles = Sets.newHashSet();

    DownstreamContext(BoundedContext downstreamContext) {
        this.downstreamContext = downstreamContext;
    }

    public String getDownstreamName() {
        return this.downstreamContext.getName();
    }

    public void addConsumedAggregates(List<Aggregate> consumedAggregates) {
        for (Aggregate aggregate : consumedAggregates) {
            if (this.consumedAggregates.stream().map(agg -> agg.getName()).collect(Collectors.toList()).contains(aggregate.getName())) continue;
            this.consumedAggregates.add(aggregate);
        }
    }

    public List<Aggregate> getConsumedAggregates() {
        return this.consumedAggregates;
    }

    public void addDownstreamRoles(List<DownstreamRole> downstreamRoles) {
        this.downstreamRoles.addAll(downstreamRoles);
    }

    public Set<DownstreamRole> getDownstreamRoles() {
        return this.downstreamRoles;
    }

    public String getDomainVisionStatement() {
        return this.downstreamContext.getDomainVisionStatement();
    }
}

